/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.core.controller;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.mock.MockHttpServletResponse;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.controller.RegisterCustomerController;
import org.broadleafcommerce.profile.web.core.controller.dataprovider.RegisterCustomerDataProvider;
import org.broadleafcommerce.profile.web.core.form.RegisterCustomerForm;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RegisterCustomerControllerTest
extends BaseTest {
    @Resource
    private RegisterCustomerController registerCustomerController;
    @Resource
    private CustomerService customerService;
    private GreenMail greenMail;

    @BeforeClass
    protected void setupControllerTest() {
        this.greenMail = new GreenMail(new ServerSetup[]{new ServerSetup(30000, "127.0.0.1", "smtp")});
        this.greenMail.start();
    }

    @AfterClass
    protected void tearDownControllerTest() {
        this.greenMail.stop();
    }

    @Test(groups={"createCustomerFromController"}, dataProvider="setupCustomerControllerData", dataProviderClass=RegisterCustomerDataProvider.class, enabled=false)
    @Transactional
    @Rollback(value=false)
    public void createCustomerFromController(RegisterCustomerForm registerCustomer) {
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult((Object)registerCustomer, "registerCustomer");
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.registerCustomerController.registerCustomer(registerCustomer, (BindingResult)errors, (HttpServletRequest)request, (HttpServletResponse)response);
        assert (errors.getErrorCount() == 0);
        Customer customerFromDb = this.customerService.readCustomerByUsername(registerCustomer.getCustomer().getUsername());
        assert (customerFromDb != null);
    }

    @Test(groups={"viewRegisterCustomerFromController"})
    public void viewRegisterCustomerFromController() {
        String view = this.registerCustomerController.registerCustomer();
        assert (view.equals("/account/registration/registerCustomer"));
    }
}

