/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.config;

import javax.annotation.Resource;
import org.broadleafcommerce.common.config.RuntimeEnvironmentPropertiesManager;
import org.broadleafcommerce.test.BaseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RuntimeEnvironmentPropertiesManagerTest
extends BaseTest {
    @Resource(name="blConfigurationManager")
    RuntimeEnvironmentPropertiesManager configurationManager;

    @Test
    public void testPropertyOnly() throws Exception {
        String s = this.configurationManager.getProperty("detect.sequence.generator.inconsistencies");
        if (s.indexOf("$") >= 0) {
            Assert.fail((String)"RuntimeEnvironmentPropertiesManager bean not defined");
        }
    }

    @Test(dependsOnMethods={"testPropertyOnly"})
    public void testPrefix() throws Exception {
        this.configurationManager.setPrefix("detect");
        String s = this.configurationManager.getProperty("sequence.generator.inconsistencies");
        if (s.indexOf("$") >= 0) {
            Assert.fail((String)"RuntimeEnvironmentPropertiesManager bean not defined");
        }
    }

    @Test(dependsOnMethods={"testPrefix"})
    public void testSuffix() throws Exception {
        String s = this.configurationManager.getProperty("sequence.generator", "inconsistencies");
        if (s.indexOf("$") >= 0) {
            Assert.fail((String)"RuntimeEnvironmentPropertiesManager bean not defined");
        }
    }

    @Test(dependsOnMethods={"testSuffix"})
    public void testNullSuffix() throws Exception {
        this.configurationManager.setPrefix("detect");
        String s = this.configurationManager.getProperty("sequence.generator.inconsistencies", "SOMETHING");
        Assert.assertNotNull((Object)s);
    }

    @Test
    public void testNULL() throws Exception {
        String s = this.configurationManager.getProperty(null, "SOMETHING");
        Assert.assertEquals((String)s, null);
    }
}

