/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.frameworkmapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.broadleafcommerce.frameworkmapping.annotation.FrameworkController;
import org.broadleafcommerce.frameworkmapping.annotation.FrameworkMapping;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class FrameworkMappingHandlerMapping
extends RequestMappingHandlerMapping {
    public static final int REQUEST_MAPPING_ORDER = 0x7FFFFFFD;

    public FrameworkMappingHandlerMapping() {
        this.setOrder(0x7FFFFFFD);
    }

    protected boolean isHandler(Class<?> beanType) {
        Class actualBeanType = ClassUtils.isCglibProxyClass(beanType) ? ClassUtils.getUserClass(beanType) : beanType;
        return AnnotationUtils.findAnnotation((AnnotatedElement)actualBeanType, FrameworkController.class) != null || AnnotationUtils.findAnnotation((AnnotatedElement)actualBeanType, FrameworkMapping.class) != null;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo typeInfo;
        RequestMappingInfo requestMappingInfo = this.createFrameworkRequestMappingInfo(method);
        if (requestMappingInfo != null && (typeInfo = this.createFrameworkRequestMappingInfo(handlerType)) != null) {
            requestMappingInfo = typeInfo.combine(requestMappingInfo);
        }
        return requestMappingInfo;
    }

    private RequestMappingInfo createFrameworkRequestMappingInfo(AnnotatedElement element) {
        FrameworkMapping frameworkMapping = (FrameworkMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, FrameworkMapping.class);
        if (frameworkMapping == null) {
            return null;
        }
        return (frameworkMapping = (FrameworkMapping)AnnotationUtils.synthesizeAnnotation((Annotation)frameworkMapping, null)) != null ? this.createRequestMappingInfo(this.convertFrameworkMappingToRequestMapping(frameworkMapping), null) : null;
    }

    private RequestMapping convertFrameworkMappingToRequestMapping(final FrameworkMapping frameworkMapping) {
        return new RequestMapping(){

            public String name() {
                return frameworkMapping.name();
            }

            public String[] value() {
                return frameworkMapping.value();
            }

            public String[] path() {
                return frameworkMapping.path();
            }

            public RequestMethod[] method() {
                return frameworkMapping.method();
            }

            public String[] params() {
                return frameworkMapping.params();
            }

            public String[] headers() {
                return frameworkMapping.headers();
            }

            public String[] consumes() {
                return frameworkMapping.consumes();
            }

            public String[] produces() {
                return frameworkMapping.produces();
            }

            public Class<? extends Annotation> annotationType() {
                return RequestMapping.class;
            }
        };
    }
}

