/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.usps.service.message.v2;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import noNamespace.RateV2RequestDocument;
import noNamespace.RateV2RequestType;
import noNamespace.RequestPackageV2Type;
import org.apache.xmlbeans.XmlTokenSource;
import org.broadleafcommerce.common.util.UnitOfMeasureUtil;
import org.broadleafcommerce.common.util.WeightUnitOfMeasureType;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItemRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceRequest;

public class USPSRequestBuilder
implements org.broadleafcommerce.vendor.usps.service.message.USPSRequestBuilder {
    @Override
    public XmlTokenSource buildRequest(USPSShippingPriceRequest request, String username, String password) {
        RateV2RequestDocument doc = RateV2RequestDocument.Factory.newInstance();
        RateV2RequestType v2Request = doc.addNewRateV2Request();
        v2Request.setUSERID(username);
        v2Request.setPASSWORD(password);
        for (USPSContainerItemRequest itemRequest : request.getContainerItems()) {
            RequestPackageV2Type requestPackage = v2Request.addNewPackage();
            if (itemRequest.getContainerShape() != null) {
                String containerShape = itemRequest.getContainerShape().getType();
                String[] tokens = containerShape.split(" ");
                StringBuffer sb = new StringBuffer();
                for (String token : tokens) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(token.substring(0, 1));
                    sb.append(token.substring(1, token.length()).toLowerCase());
                }
                requestPackage.setContainer(RequestPackageV2Type.Container.Enum.forString((String)sb.toString()));
            }
            if (itemRequest.getPackageId() != null) {
                requestPackage.setID(itemRequest.getPackageId());
            }
            if (itemRequest.isMachineSortable() != null) {
                requestPackage.setMachinable(itemRequest.isMachineSortable().booleanValue());
            }
            if (itemRequest.getWeight() != null) {
                DecimalFormat format = new DecimalFormat("0.#");
                requestPackage.setOunces(format.format(UnitOfMeasureUtil.findRemainingOunces((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()).doubleValue()));
                requestPackage.setPounds(UnitOfMeasureUtil.findWholePounds((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()));
            }
            if (itemRequest.getService() != null) {
                requestPackage.setService(RequestPackageV2Type.Service.Enum.forString((String)itemRequest.getService().getType()));
            }
            if (itemRequest.getContainerSize() != null) {
                requestPackage.setSize(RequestPackageV2Type.Size.Enum.forString((String)itemRequest.getContainerSize().getType()));
            }
            if (itemRequest.getZipDestination() != null) {
                requestPackage.setZipDestination(Integer.valueOf(itemRequest.getZipDestination()).intValue());
            }
            if (itemRequest.getZipOrigination() == null) continue;
            requestPackage.setZipOrigination(Integer.valueOf(itemRequest.getZipOrigination()).intValue());
        }
        return doc;
    }
}

