/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.usps.service.message.v3;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import noNamespace.RateV3RequestDocument;
import noNamespace.RateV3RequestType;
import noNamespace.RequestPackageV3Type;
import noNamespace.ShipDateV3Type;
import org.apache.xmlbeans.XmlTokenSource;
import org.broadleafcommerce.common.util.DimensionUnitOfMeasureType;
import org.broadleafcommerce.common.util.UnitOfMeasureUtil;
import org.broadleafcommerce.common.util.WeightUnitOfMeasureType;
import org.broadleafcommerce.vendor.usps.service.message.USPSContainerItemRequest;
import org.broadleafcommerce.vendor.usps.service.message.USPSShippingPriceRequest;

public class USPSRequestBuilder
implements org.broadleafcommerce.vendor.usps.service.message.USPSRequestBuilder {
    @Override
    public XmlTokenSource buildRequest(USPSShippingPriceRequest request, String username, String password) {
        RateV3RequestDocument doc = RateV3RequestDocument.Factory.newInstance();
        RateV3RequestType v3Request = doc.addNewRateV3Request();
        v3Request.setUSERID(username);
        v3Request.setPASSWORD(password);
        for (USPSContainerItemRequest itemRequest : request.getContainerItems()) {
            RequestPackageV3Type requestPackage = v3Request.addNewPackage();
            if (itemRequest.getContainerShape() != null) {
                requestPackage.setContainer(RequestPackageV3Type.Container.Enum.forString((String)itemRequest.getContainerShape().getType()));
            }
            if (itemRequest.getFirstClassType() != null) {
                requestPackage.setFirstClassMailType(RequestPackageV3Type.FirstClassMailType.Enum.forString((String)itemRequest.getFirstClassType().getType()));
            }
            DecimalFormat format = new DecimalFormat("0.#");
            if (itemRequest.getGirth() != null) {
                requestPackage.setGirth(format.format(UnitOfMeasureUtil.findInches((BigDecimal)itemRequest.getGirth(), (DimensionUnitOfMeasureType)itemRequest.getDimensionUnitOfMeasureType()).doubleValue()));
            }
            if (itemRequest.getHeight() != null) {
                requestPackage.setHeight(format.format(UnitOfMeasureUtil.findInches((BigDecimal)itemRequest.getHeight(), (DimensionUnitOfMeasureType)itemRequest.getDimensionUnitOfMeasureType()).doubleValue()));
            }
            if (itemRequest.getPackageId() != null) {
                requestPackage.setID(itemRequest.getPackageId());
            }
            if (itemRequest.getDepth() != null) {
                requestPackage.setLength(format.format(UnitOfMeasureUtil.findInches((BigDecimal)itemRequest.getDepth(), (DimensionUnitOfMeasureType)itemRequest.getDimensionUnitOfMeasureType()).doubleValue()));
            }
            if (itemRequest.isMachineSortable() != null) {
                requestPackage.setMachinable(itemRequest.isMachineSortable().booleanValue());
            }
            if (itemRequest.getWeight() != null) {
                requestPackage.setOunces(format.format(UnitOfMeasureUtil.findRemainingOunces((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()).doubleValue()));
                requestPackage.setPounds(UnitOfMeasureUtil.findWholePounds((BigDecimal)itemRequest.getWeight(), (WeightUnitOfMeasureType)itemRequest.getWeightUnitOfMeasureType()));
            }
            if (itemRequest.isReturnLocations() != null) {
                requestPackage.setReturnLocations(itemRequest.isReturnLocations().booleanValue());
            }
            if (itemRequest.getService() != null) {
                requestPackage.setService(RequestPackageV3Type.Service.Enum.forString((String)itemRequest.getService().getType()));
            }
            if (itemRequest.getShipDate() != null) {
                ShipDateV3Type shipDate = requestPackage.addNewShipDate();
                if (itemRequest.getShipDateOption() != null) {
                    shipDate.setOption(itemRequest.getShipDateOption().getType());
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
                shipDate.setStringValue(dateFormat.format(itemRequest.getShipDate()));
            }
            if (itemRequest.getContainerSize() != null) {
                requestPackage.setSize(RequestPackageV3Type.Size.Enum.forString((String)itemRequest.getContainerSize().getType()));
            }
            if (itemRequest.getWidth() != null) {
                requestPackage.setWidth(format.format(UnitOfMeasureUtil.findInches((BigDecimal)itemRequest.getWidth(), (DimensionUnitOfMeasureType)itemRequest.getDimensionUnitOfMeasureType()).doubleValue()));
            }
            if (itemRequest.getZipDestination() != null) {
                requestPackage.setZipDestination(Integer.valueOf(itemRequest.getZipDestination()).intValue());
            }
            if (itemRequest.getZipOrigination() == null) continue;
            requestPackage.setZipOrigination(Integer.valueOf(itemRequest.getZipOrigination()).intValue());
        }
        return doc;
    }
}

