/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.usps.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;
import org.broadleafcommerce.order.service.type.USPSServiceMethod;

public class USPSServiceType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, USPSServiceType> TYPES = new HashMap<String, USPSServiceType>();
    public static final USPSServiceType ALL = new USPSServiceType("ALL", "All");
    public static final USPSServiceType ONLINE = new USPSServiceType("ONLINE", "Online");
    public static final USPSServiceType FIRSTCLASS = new USPSServiceType("FIRST CLASS", "First Class");
    public static final USPSServiceType PRIORITY = new USPSServiceType("PRIORITY", "Priority");
    public static final USPSServiceType PRIORITYCOMMERCIAL = new USPSServiceType("PRIORITY COMMERCIAL", "Priority Commercial");
    public static final USPSServiceType EXPRESS = new USPSServiceType("EXPRESS", "Express");
    public static final USPSServiceType EXPRESS_SH = new USPSServiceType("EXPRESS SH", "Express SH");
    public static final USPSServiceType EXPRESS_HFP = new USPSServiceType("EXPRESS HFP", "Express HFP");
    public static final USPSServiceType EXPRESSCOMMERCIAL = new USPSServiceType("EXPRESS COMMERCIAL", "Express Commercial");
    public static final USPSServiceType EXPRESS_SH_COMMERCIAL = new USPSServiceType("EXPRESS SH COMMERCIAL", "Express SH Commercial");
    public static final USPSServiceType EXPRESS_HFP_COMMERCIAL = new USPSServiceType("EXPRESS HFP COMMERCIAL", "Express HFP Commercial");
    public static final USPSServiceType BPM = new USPSServiceType("BPM", "BPM");
    public static final USPSServiceType PARCEL = new USPSServiceType("PARCEL", "Parcel");
    public static final USPSServiceType MEDIA = new USPSServiceType("MEDIA", "Media");
    public static final USPSServiceType LIBRARY = new USPSServiceType("LIBRARY", "Library");
    private String type;
    private String friendlyType;

    public static USPSServiceType getInstance(String type) {
        return TYPES.get(type);
    }

    public static USPSServiceType getInstanceByServiceMethod(USPSServiceMethod method) {
        if (method.equals(USPSServiceMethod.FIRSTCLASS) || method.equals(USPSServiceMethod.FIRSTCLASSKEYSANDIDS) || method.equals(USPSServiceMethod.FIRSTCLASSPOSTCARDSTAMPED)) {
            return FIRSTCLASS;
        }
        if (method.equals(USPSServiceMethod.PRIORITYMAIL) || method.equals(USPSServiceMethod.PRIORITYMAILFLATRATEBOX) || method.equals(USPSServiceMethod.PRIORITYMAILFLATRATEENVELOPE) || method.equals(USPSServiceMethod.PRIORITYMAILFLATRATELARGEBOX) || method.equals(USPSServiceMethod.PRIORITYMAILKEYSANDIDS)) {
            return PRIORITY;
        }
        if (method.equals(USPSServiceMethod.EXPRESSMAILFLATRATEENVELOPE) || method.equals(USPSServiceMethod.EXPRESSMAILPOTOADDRESSEE)) {
            return EXPRESS;
        }
        if (method.equals(USPSServiceMethod.EXPRESSMAILFLATRATEENVELOPEHOLDFORPICKUP) || method.equals(USPSServiceMethod.EXPRESSMAILHOLDFORPICKUP)) {
            return EXPRESS_HFP;
        }
        if (method.equals(USPSServiceMethod.EXPRESSMAILFLATRATEENVELOPESUNDAYHOLIDAY) || method.equals(USPSServiceMethod.EXPRESSMAILSUNDAYHOLIDAY)) {
            return EXPRESS_SH;
        }
        if (method.equals(USPSServiceMethod.BOUNDPRINTEDMATTER)) {
            return BPM;
        }
        if (method.equals(USPSServiceMethod.PARCELPOST)) {
            return PARCEL;
        }
        if (method.equals(USPSServiceMethod.MEDIAMAIL)) {
            return MEDIA;
        }
        if (method.equals(USPSServiceMethod.LIBRARY)) {
            return LIBRARY;
        }
        return null;
    }

    public USPSServiceType() {
    }

    public USPSServiceType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        USPSServiceType other = (USPSServiceType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

