/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsRequest;

public class CoinPayments {
    private static final Logger log = Logger.getLogger(CoinPayments.class);
    private String publicKey;
    private String privateKey;
    protected HttpResponse lastResponse;
    protected CloseableHttpClient client;

    public <T> T sendRequest(CoinPaymentsRequest<T> request) throws ClientProtocolException, IOException {
        log.info((Object)("Sending request: " + request.getClass().getName()));
        request.setApi(this);
        T response = request.execute();
        log.info((Object)("Result for " + request.getClass().getName() + ": " + response));
        return response;
    }

    CoinPayments(String publicKey, String privateKey, HttpResponse lastResponse, CloseableHttpClient client) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.lastResponse = lastResponse;
        this.client = client;
    }

    public static CoinPaymentsBuilder builder() {
        return new CoinPaymentsBuilder();
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public HttpResponse getLastResponse() {
        return this.lastResponse;
    }

    public void setLastResponse(HttpResponse lastResponse) {
        this.lastResponse = lastResponse;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    static {
        log.setLevel(Level.WARN);
    }

    public static class CoinPaymentsBuilder {
        private String publicKey;
        private String privateKey;
        private HttpResponse lastResponse;
        private CloseableHttpClient client;

        CoinPaymentsBuilder() {
        }

        public CoinPaymentsBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public CoinPaymentsBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public CoinPaymentsBuilder lastResponse(HttpResponse lastResponse) {
            this.lastResponse = lastResponse;
            return this;
        }

        public CoinPaymentsBuilder client(CloseableHttpClient client) {
            this.client = client;
            return this;
        }

        public CoinPayments build() {
            return new CoinPayments(this.publicKey, this.privateKey, this.lastResponse, this.client);
        }

        public String toString() {
            return "CoinPayments.CoinPaymentsBuilder(publicKey=" + this.publicKey + ", privateKey=" + this.privateKey + ", lastResponse=" + this.lastResponse + ", client=" + this.client + ")";
        }
    }
}

