/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import lombok.NonNull;
import org.brunocvcunha.coinpayments.model.ClaimTagResponse;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsClaimTagRequest
extends CoinPaymentsPostRequest<ResponseWrapper<List<ClaimTagResponse>>> {
    @NonNull
    private String tagId;
    @NonNull
    private String name;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        return "cmd=claim_pbn_tag&tagid=" + this.tagId + "&name=" + this.name;
    }

    @Override
    public ResponseWrapper<List<ClaimTagResponse>> parseResult(int resultCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<List<ClaimTagResponse>>>(){});
        return wrapper;
    }

    public static CoinPaymentsClaimTagRequestBuilder builder() {
        return new CoinPaymentsClaimTagRequestBuilder();
    }

    public CoinPaymentsClaimTagRequest(@NonNull String tagId, @NonNull String name) {
        if (tagId == null) {
            throw new NullPointerException("tagId");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.tagId = tagId;
        this.name = name;
    }

    @NonNull
    public String getTagId() {
        return this.tagId;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setTagId(@NonNull String tagId) {
        if (tagId == null) {
            throw new NullPointerException("tagId");
        }
        this.tagId = tagId;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsClaimTagRequest)) {
            return false;
        }
        CoinPaymentsClaimTagRequest other = (CoinPaymentsClaimTagRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tagId = this.getTagId();
        String other$tagId = other.getTagId();
        if (this$tagId == null ? other$tagId != null : !this$tagId.equals(other$tagId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsClaimTagRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tagId = this.getTagId();
        result = result * 59 + ($tagId == null ? 43 : $tagId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsClaimTagRequest(tagId=" + this.getTagId() + ", name=" + this.getName() + ")";
    }

    public static class CoinPaymentsClaimTagRequestBuilder {
        private String tagId;
        private String name;

        CoinPaymentsClaimTagRequestBuilder() {
        }

        public CoinPaymentsClaimTagRequestBuilder tagId(String tagId) {
            this.tagId = tagId;
            return this;
        }

        public CoinPaymentsClaimTagRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CoinPaymentsClaimTagRequest build() {
            return new CoinPaymentsClaimTagRequest(this.tagId, this.name);
        }

        public String toString() {
            return "CoinPaymentsClaimTagRequest.CoinPaymentsClaimTagRequestBuilder(tagId=" + this.tagId + ", name=" + this.name + ")";
        }
    }
}

