/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.NonNull;
import org.brunocvcunha.coinpayments.model.ConvertCoinResponse;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsConvertCoinsRequest
extends CoinPaymentsPostRequest<ResponseWrapper<ConvertCoinResponse>> {
    @NonNull
    private double amount;
    @NonNull
    private String from;
    @NonNull
    private String to;
    private String address;
    private String destinationTag;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        return "cmd=convert&amount=" + this.amount + "&from=" + this.from + "&to=" + this.to + "&address=" + this.address + "&destinationTag" + this.destinationTag;
    }

    @Override
    public ResponseWrapper<ConvertCoinResponse> parseResult(int resultCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<ConvertCoinResponse>>(){});
        return wrapper;
    }

    private static String $default$address() {
        return "";
    }

    private static String $default$destinationTag() {
        return "";
    }

    public static CoinPaymentsConvertCoinsRequestBuilder builder() {
        return new CoinPaymentsConvertCoinsRequestBuilder();
    }

    public CoinPaymentsConvertCoinsRequest(@NonNull double amount, @NonNull String from, @NonNull String to, String address, String destinationTag) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (to == null) {
            throw new NullPointerException("to");
        }
        this.amount = amount;
        this.from = from;
        this.to = to;
        this.address = address;
        this.destinationTag = destinationTag;
    }

    @NonNull
    public double getAmount() {
        return this.amount;
    }

    @NonNull
    public String getFrom() {
        return this.from;
    }

    @NonNull
    public String getTo() {
        return this.to;
    }

    public String getAddress() {
        return this.address;
    }

    public String getDestinationTag() {
        return this.destinationTag;
    }

    public void setAmount(@NonNull double amount) {
        this.amount = amount;
    }

    public void setFrom(@NonNull String from) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        this.from = from;
    }

    public void setTo(@NonNull String to) {
        if (to == null) {
            throw new NullPointerException("to");
        }
        this.to = to;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setDestinationTag(String destinationTag) {
        this.destinationTag = destinationTag;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsConvertCoinsRequest)) {
            return false;
        }
        CoinPaymentsConvertCoinsRequest other = (CoinPaymentsConvertCoinsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$destinationTag = this.getDestinationTag();
        String other$destinationTag = other.getDestinationTag();
        return !(this$destinationTag == null ? other$destinationTag != null : !this$destinationTag.equals(other$destinationTag));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsConvertCoinsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $destinationTag = this.getDestinationTag();
        result = result * 59 + ($destinationTag == null ? 43 : $destinationTag.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsConvertCoinsRequest(amount=" + this.getAmount() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", address=" + this.getAddress() + ", destinationTag=" + this.getDestinationTag() + ")";
    }

    public static class CoinPaymentsConvertCoinsRequestBuilder {
        private double amount;
        private String from;
        private String to;
        private boolean address$set;
        private String address;
        private boolean destinationTag$set;
        private String destinationTag;

        CoinPaymentsConvertCoinsRequestBuilder() {
        }

        public CoinPaymentsConvertCoinsRequestBuilder amount(double amount) {
            this.amount = amount;
            return this;
        }

        public CoinPaymentsConvertCoinsRequestBuilder from(String from) {
            this.from = from;
            return this;
        }

        public CoinPaymentsConvertCoinsRequestBuilder to(String to) {
            this.to = to;
            return this;
        }

        public CoinPaymentsConvertCoinsRequestBuilder address(String address) {
            this.address = address;
            this.address$set = true;
            return this;
        }

        public CoinPaymentsConvertCoinsRequestBuilder destinationTag(String destinationTag) {
            this.destinationTag = destinationTag;
            this.destinationTag$set = true;
            return this;
        }

        public CoinPaymentsConvertCoinsRequest build() {
            String address = this.address;
            if (!this.address$set) {
                address = CoinPaymentsConvertCoinsRequest.$default$address();
            }
            String destinationTag = this.destinationTag;
            if (!this.destinationTag$set) {
                destinationTag = CoinPaymentsConvertCoinsRequest.$default$destinationTag();
            }
            return new CoinPaymentsConvertCoinsRequest(this.amount, this.from, this.to, address, destinationTag);
        }

        public String toString() {
            return "CoinPaymentsConvertCoinsRequest.CoinPaymentsConvertCoinsRequestBuilder(amount=" + this.amount + ", from=" + this.from + ", to=" + this.to + ", address=" + this.address + ", destinationTag=" + this.destinationTag + ")";
        }
    }
}

