/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.brunocvcunha.coinpayments.model.CreateWithdrawalResponse;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsCreateMassWithdrawalRequest
extends CoinPaymentsPostRequest<ResponseWrapper<Map<String, CreateWithdrawalResponse>>> {
    @NonNull
    private List<Map<String, String>> wd;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.wd.size(); ++i) {
            Map<String, String> entries = this.wd.get(i);
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                sb.append("&wd[wd").append(i).append("][").append(entry.getKey()).append("]").append("=").append(entry.getValue());
            }
        }
        return "cmd=create_mass_withdrawal" + sb.toString();
    }

    @Override
    public ResponseWrapper<Map<String, CreateWithdrawalResponse>> parseResult(int resultCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<Map<String, CreateWithdrawalResponse>>>(){});
        return wrapper;
    }

    public static CoinPaymentsCreateMassWithdrawalRequestBuilder builder() {
        return new CoinPaymentsCreateMassWithdrawalRequestBuilder();
    }

    public CoinPaymentsCreateMassWithdrawalRequest(@NonNull List<Map<String, String>> wd) {
        if (wd == null) {
            throw new NullPointerException("wd");
        }
        this.wd = wd;
    }

    @NonNull
    public List<Map<String, String>> getWd() {
        return this.wd;
    }

    public void setWd(@NonNull List<Map<String, String>> wd) {
        if (wd == null) {
            throw new NullPointerException("wd");
        }
        this.wd = wd;
    }

    @Override
    public String toString() {
        return "CoinPaymentsCreateMassWithdrawalRequest(wd=" + this.getWd() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsCreateMassWithdrawalRequest)) {
            return false;
        }
        CoinPaymentsCreateMassWithdrawalRequest other = (CoinPaymentsCreateMassWithdrawalRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Map<String, String>> this$wd = this.getWd();
        List<Map<String, String>> other$wd = other.getWd();
        return !(this$wd == null ? other$wd != null : !((Object)this$wd).equals(other$wd));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsCreateMassWithdrawalRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Map<String, String>> $wd = this.getWd();
        result = result * 59 + ($wd == null ? 43 : ((Object)$wd).hashCode());
        return result;
    }

    public static class CoinPaymentsCreateMassWithdrawalRequestBuilder {
        private List<Map<String, String>> wd;

        CoinPaymentsCreateMassWithdrawalRequestBuilder() {
        }

        public CoinPaymentsCreateMassWithdrawalRequestBuilder wd(List<Map<String, String>> wd) {
            this.wd = wd;
            return this;
        }

        public CoinPaymentsCreateMassWithdrawalRequest build() {
            return new CoinPaymentsCreateMassWithdrawalRequest(this.wd);
        }

        public String toString() {
            return "CoinPaymentsCreateMassWithdrawalRequest.CoinPaymentsCreateMassWithdrawalRequestBuilder(wd=" + this.wd + ")";
        }
    }
}

