/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.NonNull;
import org.brunocvcunha.coinpayments.model.CreateWithdrawalResponse;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsCreateWithdrawalRequest
extends CoinPaymentsPostRequest<ResponseWrapper<CreateWithdrawalResponse>> {
    @NonNull
    private double amount;
    private boolean addTransactionFee;
    @NonNull
    private String currency;
    private String withdrawCurrency;
    @NonNull
    private String address;
    private String destinationTag;
    private String ipnURL;
    private boolean autoConfirm;
    private String note;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        return "cmd=create_withdrawal&amount=" + this.amount + "&add_tx_fee=" + (this.addTransactionFee ? 1 : 0) + "&currency=" + this.currency + "&currency2=" + this.withdrawCurrency + "&address=" + this.address + "&dest_tag=" + this.destinationTag + "&ipn_url=" + this.ipnURL + "&auto_confirm=" + (this.autoConfirm ? 1 : 0) + "&note=" + this.note;
    }

    @Override
    public ResponseWrapper<CreateWithdrawalResponse> parseResult(int resultCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<CreateWithdrawalResponse>>(){});
        return wrapper;
    }

    private static boolean $default$addTransactionFee() {
        return false;
    }

    private static String $default$withdrawCurrency() {
        return "";
    }

    private static String $default$destinationTag() {
        return "";
    }

    private static String $default$ipnURL() {
        return "";
    }

    private static boolean $default$autoConfirm() {
        return true;
    }

    private static String $default$note() {
        return "";
    }

    public static CoinPaymentsCreateWithdrawalRequestBuilder builder() {
        return new CoinPaymentsCreateWithdrawalRequestBuilder();
    }

    public CoinPaymentsCreateWithdrawalRequest(@NonNull double amount, @NonNull String currency, @NonNull String address) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.amount = amount;
        this.currency = currency;
        this.address = address;
    }

    public CoinPaymentsCreateWithdrawalRequest(@NonNull double amount, boolean addTransactionFee, @NonNull String currency, String withdrawCurrency, @NonNull String address, String destinationTag, String ipnURL, boolean autoConfirm, String note) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.amount = amount;
        this.addTransactionFee = addTransactionFee;
        this.currency = currency;
        this.withdrawCurrency = withdrawCurrency;
        this.address = address;
        this.destinationTag = destinationTag;
        this.ipnURL = ipnURL;
        this.autoConfirm = autoConfirm;
        this.note = note;
    }

    @NonNull
    public double getAmount() {
        return this.amount;
    }

    public boolean isAddTransactionFee() {
        return this.addTransactionFee;
    }

    @NonNull
    public String getCurrency() {
        return this.currency;
    }

    public String getWithdrawCurrency() {
        return this.withdrawCurrency;
    }

    @NonNull
    public String getAddress() {
        return this.address;
    }

    public String getDestinationTag() {
        return this.destinationTag;
    }

    public String getIpnURL() {
        return this.ipnURL;
    }

    public boolean isAutoConfirm() {
        return this.autoConfirm;
    }

    public String getNote() {
        return this.note;
    }

    public void setAmount(@NonNull double amount) {
        this.amount = amount;
    }

    public void setAddTransactionFee(boolean addTransactionFee) {
        this.addTransactionFee = addTransactionFee;
    }

    public void setCurrency(@NonNull String currency) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        this.currency = currency;
    }

    public void setWithdrawCurrency(String withdrawCurrency) {
        this.withdrawCurrency = withdrawCurrency;
    }

    public void setAddress(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.address = address;
    }

    public void setDestinationTag(String destinationTag) {
        this.destinationTag = destinationTag;
    }

    public void setIpnURL(String ipnURL) {
        this.ipnURL = ipnURL;
    }

    public void setAutoConfirm(boolean autoConfirm) {
        this.autoConfirm = autoConfirm;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsCreateWithdrawalRequest)) {
            return false;
        }
        CoinPaymentsCreateWithdrawalRequest other = (CoinPaymentsCreateWithdrawalRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (this.isAddTransactionFee() != other.isAddTransactionFee()) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$withdrawCurrency = this.getWithdrawCurrency();
        String other$withdrawCurrency = other.getWithdrawCurrency();
        if (this$withdrawCurrency == null ? other$withdrawCurrency != null : !this$withdrawCurrency.equals(other$withdrawCurrency)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$destinationTag = this.getDestinationTag();
        String other$destinationTag = other.getDestinationTag();
        if (this$destinationTag == null ? other$destinationTag != null : !this$destinationTag.equals(other$destinationTag)) {
            return false;
        }
        String this$ipnURL = this.getIpnURL();
        String other$ipnURL = other.getIpnURL();
        if (this$ipnURL == null ? other$ipnURL != null : !this$ipnURL.equals(other$ipnURL)) {
            return false;
        }
        if (this.isAutoConfirm() != other.isAutoConfirm()) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        return !(this$note == null ? other$note != null : !this$note.equals(other$note));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsCreateWithdrawalRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        result = result * 59 + (this.isAddTransactionFee() ? 79 : 97);
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $withdrawCurrency = this.getWithdrawCurrency();
        result = result * 59 + ($withdrawCurrency == null ? 43 : $withdrawCurrency.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $destinationTag = this.getDestinationTag();
        result = result * 59 + ($destinationTag == null ? 43 : $destinationTag.hashCode());
        String $ipnURL = this.getIpnURL();
        result = result * 59 + ($ipnURL == null ? 43 : $ipnURL.hashCode());
        result = result * 59 + (this.isAutoConfirm() ? 79 : 97);
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsCreateWithdrawalRequest(amount=" + this.getAmount() + ", addTransactionFee=" + this.isAddTransactionFee() + ", currency=" + this.getCurrency() + ", withdrawCurrency=" + this.getWithdrawCurrency() + ", address=" + this.getAddress() + ", destinationTag=" + this.getDestinationTag() + ", ipnURL=" + this.getIpnURL() + ", autoConfirm=" + this.isAutoConfirm() + ", note=" + this.getNote() + ")";
    }

    public static class CoinPaymentsCreateWithdrawalRequestBuilder {
        private double amount;
        private boolean addTransactionFee$set;
        private boolean addTransactionFee;
        private String currency;
        private boolean withdrawCurrency$set;
        private String withdrawCurrency;
        private String address;
        private boolean destinationTag$set;
        private String destinationTag;
        private boolean ipnURL$set;
        private String ipnURL;
        private boolean autoConfirm$set;
        private boolean autoConfirm;
        private boolean note$set;
        private String note;

        CoinPaymentsCreateWithdrawalRequestBuilder() {
        }

        public CoinPaymentsCreateWithdrawalRequestBuilder amount(double amount) {
            this.amount = amount;
            return this;
        }

        public CoinPaymentsCreateWithdrawalRequestBuilder addTransactionFee(boolean addTransactionFee) {
            this.addTransactionFee = addTransactionFee;
            this.addTransactionFee$set = true;
            return this;
        }

        public CoinPaymentsCreateWithdrawalRequestBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public CoinPaymentsCreateWithdrawalRequestBuilder withdrawCurrency(String withdrawCurrency) {
            this.withdrawCurrency = withdrawCurrency;
            this.withdrawCurrency$set = true;
            return this;
        }

        public CoinPaymentsCreateWithdrawalRequestBuilder address(String address) {
            this.address = address;
            return this;
        }

        public CoinPaymentsCreateWithdrawalRequestBuilder destinationTag(String destinationTag) {
            this.destinationTag = destinationTag;
            this.destinationTag$set = true;
            return this;
        }

        public CoinPaymentsCreateWithdrawalRequestBuilder ipnURL(String ipnURL) {
            this.ipnURL = ipnURL;
            this.ipnURL$set = true;
            return this;
        }

        public CoinPaymentsCreateWithdrawalRequestBuilder autoConfirm(boolean autoConfirm) {
            this.autoConfirm = autoConfirm;
            this.autoConfirm$set = true;
            return this;
        }

        public CoinPaymentsCreateWithdrawalRequestBuilder note(String note) {
            this.note = note;
            this.note$set = true;
            return this;
        }

        public CoinPaymentsCreateWithdrawalRequest build() {
            boolean addTransactionFee = this.addTransactionFee;
            if (!this.addTransactionFee$set) {
                addTransactionFee = CoinPaymentsCreateWithdrawalRequest.$default$addTransactionFee();
            }
            String withdrawCurrency = this.withdrawCurrency;
            if (!this.withdrawCurrency$set) {
                withdrawCurrency = CoinPaymentsCreateWithdrawalRequest.$default$withdrawCurrency();
            }
            String destinationTag = this.destinationTag;
            if (!this.destinationTag$set) {
                destinationTag = CoinPaymentsCreateWithdrawalRequest.$default$destinationTag();
            }
            String ipnURL = this.ipnURL;
            if (!this.ipnURL$set) {
                ipnURL = CoinPaymentsCreateWithdrawalRequest.$default$ipnURL();
            }
            boolean autoConfirm = this.autoConfirm;
            if (!this.autoConfirm$set) {
                autoConfirm = CoinPaymentsCreateWithdrawalRequest.$default$autoConfirm();
            }
            String note = this.note;
            if (!this.note$set) {
                note = CoinPaymentsCreateWithdrawalRequest.$default$note();
            }
            return new CoinPaymentsCreateWithdrawalRequest(this.amount, addTransactionFee, this.currency, withdrawCurrency, this.address, destinationTag, ipnURL, autoConfirm, note);
        }

        public String toString() {
            return "CoinPaymentsCreateWithdrawalRequest.CoinPaymentsCreateWithdrawalRequestBuilder(amount=" + this.amount + ", addTransactionFee=" + this.addTransactionFee + ", currency=" + this.currency + ", withdrawCurrency=" + this.withdrawCurrency + ", address=" + this.address + ", destinationTag=" + this.destinationTag + ", ipnURL=" + this.ipnURL + ", autoConfirm=" + this.autoConfirm + ", note=" + this.note + ")";
        }
    }
}

