/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import org.brunocvcunha.coinpayments.model.AddressResponse;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsDepositRequest
extends CoinPaymentsPostRequest<ResponseWrapper<AddressResponse>> {
    private String currency;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        return "cmd=get_deposit_address&currency=" + this.currency;
    }

    @Override
    public ResponseWrapper<AddressResponse> parseResult(int resultCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<AddressResponse>>(){});
        return wrapper;
    }

    public static CoinPaymentsDepositRequestBuilder builder() {
        return new CoinPaymentsDepositRequestBuilder();
    }

    public CoinPaymentsDepositRequest(String currency) {
        this.currency = currency;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsDepositRequest)) {
            return false;
        }
        CoinPaymentsDepositRequest other = (CoinPaymentsDepositRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsDepositRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsDepositRequest(currency=" + this.getCurrency() + ")";
    }

    public static class CoinPaymentsDepositRequestBuilder {
        private String currency;

        CoinPaymentsDepositRequestBuilder() {
        }

        public CoinPaymentsDepositRequestBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public CoinPaymentsDepositRequest build() {
            return new CoinPaymentsDepositRequest(this.currency);
        }

        public String toString() {
            return "CoinPaymentsDepositRequest.CoinPaymentsDepositRequestBuilder(currency=" + this.currency + ")";
        }
    }
}

