/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.NonNull;
import org.brunocvcunha.coinpayments.model.AddressResponse;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsGetCallbackAddressRequest
extends CoinPaymentsPostRequest<ResponseWrapper<AddressResponse>> {
    @NonNull
    private String currency;
    private String IPNUrl;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        return "cmd=get_callback_address&currency=" + this.currency + "&ipn_url=" + this.IPNUrl;
    }

    @Override
    public ResponseWrapper<AddressResponse> parseResult(int resultCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<AddressResponse>>(){});
        return wrapper;
    }

    private static String $default$IPNUrl() {
        return "";
    }

    public static CoinPaymentsGetCallbackAddressRequestBuilder builder() {
        return new CoinPaymentsGetCallbackAddressRequestBuilder();
    }

    public CoinPaymentsGetCallbackAddressRequest(@NonNull String currency) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        this.currency = currency;
    }

    public CoinPaymentsGetCallbackAddressRequest(@NonNull String currency, String IPNUrl) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        this.currency = currency;
        this.IPNUrl = IPNUrl;
    }

    @NonNull
    public String getCurrency() {
        return this.currency;
    }

    public String getIPNUrl() {
        return this.IPNUrl;
    }

    public void setCurrency(@NonNull String currency) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        this.currency = currency;
    }

    public void setIPNUrl(String IPNUrl) {
        this.IPNUrl = IPNUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsGetCallbackAddressRequest)) {
            return false;
        }
        CoinPaymentsGetCallbackAddressRequest other = (CoinPaymentsGetCallbackAddressRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$IPNUrl = this.getIPNUrl();
        String other$IPNUrl = other.getIPNUrl();
        return !(this$IPNUrl == null ? other$IPNUrl != null : !this$IPNUrl.equals(other$IPNUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsGetCallbackAddressRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $IPNUrl = this.getIPNUrl();
        result = result * 59 + ($IPNUrl == null ? 43 : $IPNUrl.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsGetCallbackAddressRequest(currency=" + this.getCurrency() + ", IPNUrl=" + this.getIPNUrl() + ")";
    }

    public static class CoinPaymentsGetCallbackAddressRequestBuilder {
        private String currency;
        private boolean IPNUrl$set;
        private String IPNUrl;

        CoinPaymentsGetCallbackAddressRequestBuilder() {
        }

        public CoinPaymentsGetCallbackAddressRequestBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public CoinPaymentsGetCallbackAddressRequestBuilder IPNUrl(String IPNUrl) {
            this.IPNUrl = IPNUrl;
            this.IPNUrl$set = true;
            return this;
        }

        public CoinPaymentsGetCallbackAddressRequest build() {
            String IPNUrl = this.IPNUrl;
            if (!this.IPNUrl$set) {
                IPNUrl = CoinPaymentsGetCallbackAddressRequest.$default$IPNUrl();
            }
            return new CoinPaymentsGetCallbackAddressRequest(this.currency, IPNUrl);
        }

        public String toString() {
            return "CoinPaymentsGetCallbackAddressRequest.CoinPaymentsGetCallbackAddressRequestBuilder(currency=" + this.currency + ", IPNUrl=" + this.IPNUrl + ")";
        }
    }
}

