/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import org.brunocvcunha.coinpayments.model.ResponseWrapper;
import org.brunocvcunha.coinpayments.requests.base.CoinPaymentsPostRequest;

public class CoinPaymentsGetTransactionListRequest
extends CoinPaymentsPostRequest<ResponseWrapper<List<String>>> {
    private int limit;
    private long start;
    private int newer;
    private int all;

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getPayload() {
        return "cmd=get_tx_ids&limit=" + this.limit + "&start=" + this.start + "&newer=" + this.newer + "&all=" + this.all;
    }

    @Override
    public ResponseWrapper<List<String>> parseResult(int resultCode, String content) {
        ResponseWrapper wrapper = (ResponseWrapper)this.parseJson(content, new TypeReference<ResponseWrapper<List<String>>>(){});
        return wrapper;
    }

    private static int $default$limit() {
        return 25;
    }

    private static long $default$start() {
        return 0L;
    }

    private static int $default$newer() {
        return 0;
    }

    private static int $default$all() {
        return 0;
    }

    public static CoinPaymentsGetTransactionListRequestBuilder builder() {
        return new CoinPaymentsGetTransactionListRequestBuilder();
    }

    public CoinPaymentsGetTransactionListRequest(int limit, long start, int newer, int all) {
        this.limit = limit;
        this.start = start;
        this.newer = newer;
        this.all = all;
    }

    public CoinPaymentsGetTransactionListRequest() {
    }

    public int getLimit() {
        return this.limit;
    }

    public long getStart() {
        return this.start;
    }

    public int getNewer() {
        return this.newer;
    }

    public int getAll() {
        return this.all;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setNewer(int newer) {
        this.newer = newer;
    }

    public void setAll(int all) {
        this.all = all;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsGetTransactionListRequest)) {
            return false;
        }
        CoinPaymentsGetTransactionListRequest other = (CoinPaymentsGetTransactionListRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (this.getNewer() != other.getNewer()) {
            return false;
        }
        return this.getAll() == other.getAll();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsGetTransactionListRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimit();
        long $start = this.getStart();
        result = result * 59 + (int)($start >>> 32 ^ $start);
        result = result * 59 + this.getNewer();
        result = result * 59 + this.getAll();
        return result;
    }

    @Override
    public String toString() {
        return "CoinPaymentsGetTransactionListRequest(limit=" + this.getLimit() + ", start=" + this.getStart() + ", newer=" + this.getNewer() + ", all=" + this.getAll() + ")";
    }

    public static class CoinPaymentsGetTransactionListRequestBuilder {
        private boolean limit$set;
        private int limit;
        private boolean start$set;
        private long start;
        private boolean newer$set;
        private int newer;
        private boolean all$set;
        private int all;

        CoinPaymentsGetTransactionListRequestBuilder() {
        }

        public CoinPaymentsGetTransactionListRequestBuilder limit(int limit) {
            this.limit = limit;
            this.limit$set = true;
            return this;
        }

        public CoinPaymentsGetTransactionListRequestBuilder start(long start) {
            this.start = start;
            this.start$set = true;
            return this;
        }

        public CoinPaymentsGetTransactionListRequestBuilder newer(int newer) {
            this.newer = newer;
            this.newer$set = true;
            return this;
        }

        public CoinPaymentsGetTransactionListRequestBuilder all(int all) {
            this.all = all;
            this.all$set = true;
            return this;
        }

        public CoinPaymentsGetTransactionListRequest build() {
            int limit = this.limit;
            if (!this.limit$set) {
                limit = CoinPaymentsGetTransactionListRequest.$default$limit();
            }
            long start = this.start;
            if (!this.start$set) {
                start = CoinPaymentsGetTransactionListRequest.$default$start();
            }
            int newer = this.newer;
            if (!this.newer$set) {
                newer = CoinPaymentsGetTransactionListRequest.$default$newer();
            }
            int all = this.all;
            if (!this.all$set) {
                all = CoinPaymentsGetTransactionListRequest.$default$all();
            }
            return new CoinPaymentsGetTransactionListRequest(limit, start, newer, all);
        }

        public String toString() {
            return "CoinPaymentsGetTransactionListRequest.CoinPaymentsGetTransactionListRequestBuilder(limit=" + this.limit + ", start=" + this.start + ", newer=" + this.newer + ", all=" + this.all + ")";
        }
    }
}

