/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.requests.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.ClientProtocolException;
import org.apache.log4j.Logger;
import org.brunocvcunha.coinpayments.CoinPayments;
import org.brunocvcunha.inutils4j.MyStreamUtils;

public abstract class CoinPaymentsRequest<T> {
    private static final Logger log = Logger.getLogger(CoinPaymentsRequest.class);
    @JsonIgnore
    protected CoinPayments api;

    public abstract String getUrl();

    public abstract String getMethod();

    public String getPayload() {
        return null;
    }

    public abstract T execute() throws ClientProtocolException, IOException;

    public abstract T parseResult(int var1, String var2);

    public <U> U parseJson(String str, Class<U> clazz) {
        log.trace((Object)("Reading " + clazz.getSimpleName() + " from " + str));
        return (U)new ObjectMapper().readValue(str, clazz);
    }

    public <U> U parseJson(String str, TypeReference<T> type) {
        log.trace((Object)("Reading " + type.getType() + " from " + str));
        return (U)new ObjectMapper().readValue(str, type);
    }

    public T parseJson(InputStream is, Class<T> clazz) {
        return this.parseJson(MyStreamUtils.readContent((InputStream)is), clazz);
    }

    public CoinPaymentsRequest(CoinPayments api) {
        this.api = api;
    }

    public CoinPaymentsRequest() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoinPaymentsRequest)) {
            return false;
        }
        CoinPaymentsRequest other = (CoinPaymentsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CoinPayments this$api = this.getApi();
        CoinPayments other$api = other.getApi();
        return !(this$api == null ? other$api != null : !this$api.equals(other$api));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CoinPaymentsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CoinPayments $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        return result;
    }

    public CoinPayments getApi() {
        return this.api;
    }

    public void setApi(CoinPayments api) {
        this.api = api;
    }
}

