/*
 * Decompiled with CFR 0.152.
 */
package org.brunocvcunha.coinpayments.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class OptionalArrayDeserializer<T>
extends JsonDeserializer<List<T>> {
    private final Class<T> clazz;

    public OptionalArrayDeserializer(Class<T> clazz) {
        this.clazz = clazz;
    }

    public List<T> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jp);
        ArrayList<Object> list = new ArrayList<Object>();
        if (node.isArray()) {
            for (JsonNode elementNode : node) {
                list.add(oc.treeToValue((TreeNode)elementNode, this.clazz));
            }
        } else {
            list.add(oc.treeToValue((TreeNode)node, this.clazz));
        }
        return list;
    }
}

