/*
 * Decompiled with CFR 0.152.
 */
package org.brylex.maven.execjar;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader
extends URLClassLoader {
    public JarClassLoader(ClassLoader systemClassLoader) {
        super(JarClassLoader.urls(JarClassLoader.getUrls(systemClassLoader), JarClassLoader.url("file://./etc/")), systemClassLoader.getParent());
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isServerJar(String fileName) {
        return fileName != null && fileName.startsWith("META-INF/jars/") && fileName.toLowerCase().endsWith(".jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File jarEntryAsFile(JarFile jarFile, JarEntry jarEntry) throws IOException {
        File file;
        InputStream input = null;
        FileOutputStream output = null;
        try {
            int readCount;
            String name = jarEntry.getName().replace('/', '_');
            int i = name.lastIndexOf(".");
            String extension = i > -1 ? name.substring(i) : "";
            File file2 = File.createTempFile(name.substring(0, name.length() - extension.length()) + ".", extension);
            file2.deleteOnExit();
            input = jarFile.getInputStream(jarEntry);
            output = new FileOutputStream(file2);
            byte[] buffer = new byte[4096];
            while ((readCount = input.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, readCount);
            }
            file = file2;
        }
        catch (Throwable throwable) {
            JarClassLoader.close(input);
            JarClassLoader.close(output);
            throw throwable;
        }
        JarClassLoader.close(input);
        JarClassLoader.close(output);
        return file;
    }

    private static URL[] urls(URL[] urls, URL ... additionalUrls) {
        ArrayList<URL> list = new ArrayList<URL>(Arrays.asList(urls));
        try {
            ProtectionDomain protectionDomain = JarClassLoader.class.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL rootJarUrl = codeSource.getLocation();
            File warFile = new File(rootJarUrl.getPath());
            JarFile jarFile = new JarFile(warFile);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if (!JarClassLoader.isServerJar(jarEntry.getName())) continue;
                File file = JarClassLoader.jarEntryAsFile(jarFile, jarEntry);
                list.add(file.toURI().toURL());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to instantiate server classloader.", e);
        }
        for (URL additionalUrl : additionalUrls) {
            list.add(additionalUrl);
        }
        URL[] array = new URL[list.size()];
        return list.toArray(array);
    }

    private static URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static URL[] getUrls(ClassLoader cl) {
        return ((URLClassLoader)cl).getURLs();
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                clazz = this.findClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }
}

