/*
 * Decompiled with CFR 0.152.
 */
package org.brylex.maven.execjar.mojo;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="exec-jar", threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ExecJarMojo
extends AbstractMojo
implements Contextualizable {
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    private String finalName;
    @Parameter(name="mainClass", required=true)
    private String mainClass;
    @Parameter(name="binary", required=false, defaultValue="false")
    private boolean binary;
    private List<ArtifactRepository> repositories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"\n### Executable JAR Plugin ###\n\n");
        this.getLog().info((CharSequence)("     Artifact: " + this.project.getArtifact()));
        this.getLog().info((CharSequence)("   Main class: " + this.mainClass));
        if (!this.project.getArtifact().getType().equalsIgnoreCase("jar")) {
            throw new MojoFailureException("Uber JAR plugin can ONLY be used on JAR-type artifacts.");
        }
        Path jarPath = new File(this.outputDirectory, this.finalName + "-uber.jar").toPath();
        File outputFile = jarPath.toFile();
        this.outputDirectory.mkdirs();
        Manifest manifest = new Manifest();
        Attributes global = manifest.getMainAttributes();
        global.put(Attributes.Name.MANIFEST_VERSION, this.project.getVersion());
        global.put(Attributes.Name.MAIN_CLASS, "org.brylex.maven.execjar.MainDelegator");
        try (JarOutputStream os = new JarOutputStream((OutputStream)new FileOutputStream(outputFile), manifest);){
            os.putNextEntry(new JarEntry("META-INF/"));
            os.putNextEntry(new JarEntry("META-INF/jars/"));
            this.addArtifact(this.project.getArtifact(), os);
            for (Artifact artifact : this.project.getArtifacts()) {
                this.addArtifact(artifact, os);
            }
            for (Artifact artifact : this.project.getPluginArtifacts()) {
                if (!artifact.getArtifactId().equals("exec-jar")) continue;
                artifact = this.localRepository.find(artifact);
                JarInputStream jis = new JarInputStream(new FileInputStream(artifact.getFile()));
                Throwable throwable = null;
                try {
                    JarEntry entry;
                    while ((entry = jis.getNextJarEntry()) != null) {
                        if (!entry.getName().endsWith(".class") || entry.getName().endsWith("Mojo.class")) continue;
                        JarEntry jj = new JarEntry(entry.getName());
                        jj.setTime(entry.getTime());
                        os.putNextEntry(jj);
                        IOUtil.copy((InputStream)jis, (OutputStream)os);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jis == null) continue;
                    if (throwable != null) {
                        try {
                            jis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jis.close();
                }
            }
            JarEntry entry = new JarEntry("META-INF/exec-jar.properties");
            os.putNextEntry(entry);
            Properties properties = new Properties();
            properties.setProperty("mainClass", this.mainClass);
            properties.store(os, "Created by User JAR Plugin");
            this.getLog().info((CharSequence)("Successfully created Uber JAR [" + jarPath + "]."));
            this.projectHelper.attachArtifact(this.project, "jar", "uber", jarPath.toFile());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create executable JAR.", e);
        }
        if (this.binary) {
            Path binPath = new File(this.outputDirectory, this.finalName + "-bin").toPath();
            try {
                OutputStream os = Files.newOutputStream(binPath, StandardOpenOption.APPEND, StandardOpenOption.CREATE_NEW);
                Object object = null;
                try {
                    try (InputStream is = ExecJarMojo.class.getResourceAsStream("/stub.sh");){
                        ByteStreams.copy((InputStream)is, (OutputStream)os);
                    }
                    Files.copy(jarPath, os);
                    Files.setPosixFilePermissions(binPath, PosixFilePermissions.fromString("rwxr-xr-x"));
                    this.getLog().info((CharSequence)("Successfully created Linux binary [" + binPath + "]."));
                    this.projectHelper.attachArtifact(this.project, "bin", binPath.toFile());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (os != null) {
                        if (object != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create Linux binary.", (Exception)e);
            }
        }
    }

    private void addArtifact(Artifact artifact, JarOutputStream target) throws IOException {
        String name = "META-INF/jars/" + artifact.getFile().getName();
        JarEntry entry = new JarEntry(name);
        entry.setTime(artifact.getFile().lastModified());
        target.putNextEntry(entry);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(artifact.getFile()));){
            IOUtil.copy((InputStream)is, (OutputStream)target);
        }
    }

    public void contextualize(Context context) throws ContextException {
    }
}

