/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.bean.jpa;

import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.PropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtils;
import org.bsc.bean.AbstractBeanManager;
import org.bsc.bean.ManagedBeanInfo;
import org.bsc.bean.ManagedBeanInfoProxy;
import org.bsc.bean.jpa.JPAManagedBeanInfo;
import org.bsc.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPABeanManager<T>
extends AbstractBeanManager<T> {
    public JPABeanManager(ManagedBeanInfo<T> beanInfo) {
        super(beanInfo);
    }

    public JPABeanManager(Class<T> bean, BeanInfo beanInfo) {
        super(bean, beanInfo);
    }

    protected Object invokeReadMethod(PropertyDescriptor pd, Object beanInstance) throws Exception {
        String rattr = (String)pd.getValue("relation.attribute");
        if (rattr != null) {
            String nestedProperty = String.format("%s.%s", pd.getName(), rattr);
            Log.debug((String)("====> GET JOIN PROPERTY " + nestedProperty), (Object[])new Object[0]);
            return PropertyUtils.getNestedProperty((Object)beanInstance, (String)nestedProperty);
        }
        return super.invokeReadMethod(pd, beanInstance);
    }

    protected Object invokeWriteMethod(PropertyDescriptor pd, Object beanInstance, Object value) throws Exception {
        String rname = (String)pd.getValue("relation.name");
        if (rname != null) {
            String nestedProperty = String.format("%s.%s", rname, pd.getName());
            Log.debug((String)"====> SET JOIN PROPERTY [{0}]=[{1}]", (Object[])new Object[]{nestedProperty, value.getClass().getName()});
            PropertyUtils.setNestedProperty((Object)beanInstance, (String)nestedProperty, (Object)value);
            return null;
        }
        String rattr = (String)pd.getValue("relation.attribute");
        if (rattr != null) {
            String nestedProperty = String.format("%s.%s", pd.getName(), rattr);
            Log.debug((String)"====> SET JOIN PROPERTY {0}]=[{1}]", (Object[])new Object[]{nestedProperty, value});
            PropertyUtils.setNestedProperty((Object)beanInstance, (String)nestedProperty, (Object)value);
            return null;
        }
        return super.invokeWriteMethod(pd, beanInstance, value);
    }

    public T instantiateBean() throws InstantiationException {
        Log.debug((String)"INSTANTIATE BEAN [{0}]", (Object[])new Object[]{this.getBeanClass()});
        try {
            Object result = Beans.instantiate(this.getBeanClass().getClassLoader(), this.getBeanClass().getName());
            Log.debug((String)"INSTANTIATE BEAN [{0}]", (Object[])new Object[]{result});
            BeanInfo bi = super.getBeanInfo();
            JPAManagedBeanInfo beanInfo = null;
            beanInfo = bi instanceof ManagedBeanInfoProxy ? (JPAManagedBeanInfo)((Object)((ManagedBeanInfoProxy)bi).getDelegate()) : (JPAManagedBeanInfo)((Object)bi);
            if (beanInfo.relationBeanList != null) {
                for (JPAManagedBeanInfo.RelationBeanFactory rbf : beanInfo.relationBeanList) {
                    rbf.createAndSet(result);
                }
            }
            return (T)result;
        }
        catch (Exception ex) {
            throw new InstantiationException(ex.getMessage());
        }
    }
}

