/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.bean.jpa;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.bsc.bean.BeanDescriptorEntity;
import org.bsc.bean.BeanManagerUtils;
import org.bsc.bean.JoinCondition;
import org.bsc.bean.ManagedBeanInfo;
import org.bsc.bean.PropertyDescriptorField;
import org.bsc.bean.PropertyDescriptorJoin;
import org.bsc.bean.PropertyDescriptorPK;
import org.bsc.bean.ValueGenerator;
import org.bsc.bean.generators.UUIDValueGenerator;
import org.bsc.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAManagedBeanInfo<T>
implements ManagedBeanInfo<T> {
    protected Class<T> beanClass;
    protected List<RelationBeanFactory> relationBeanList;
    private List<JPAManagedBeanInfo<?>> additionalList;
    protected Map<String, PropertyDescriptor> properties = null;
    protected BeanDescriptorEntity beanDescriptor = null;

    protected static PropertyDescriptor processJoin(JPAManagedBeanInfo<?> result, AnnotatedElement f, OneToOne relation, PropertyDescriptor pd) throws Exception {
        PropertyDescriptor[] pp;
        if (relation == null || pd == null) {
            return null;
        }
        JoinColumn jc = f.getAnnotation(JoinColumn.class);
        if (jc == null) {
            throw new IllegalStateException("JoinColumn Info is not set!");
        }
        String jtable = null;
        Class<?> type = pd.getPropertyType();
        if (result.relationBeanList == null) {
            result.relationBeanList = new ArrayList<RelationBeanFactory>(5);
        }
        result.relationBeanList.add(new RelationBeanFactory(type, pd.getWriteMethod()));
        String fieldA = jc.name();
        String fieldB = jc.referencedColumnName();
        Table joinTable = type.getAnnotation(Table.class);
        jtable = joinTable != null ? joinTable.name() : (jc.table() == null || jc.table().isEmpty() ? type.getSimpleName() : jc.table());
        PropertyDescriptorField pf = new PropertyDescriptorField(pd);
        pf.setFieldName(fieldA);
        pf.setValue("relation.attribute", (Object)fieldB.toLowerCase());
        BeanDescriptorEntity bde = (BeanDescriptorEntity)result.getBeanDescriptor();
        bde.createJoinRelation(jtable, new JoinCondition[]{new JoinCondition(fieldA, fieldB)});
        JPAManagedBeanInfo<?> beanInfo = JPAManagedBeanInfo.create(type);
        for (PropertyDescriptor ppd : pp = beanInfo.getPropertyDescriptors()) {
            if (ppd instanceof PropertyDescriptorJoin || !(ppd instanceof PropertyDescriptorField)) continue;
            PropertyDescriptorJoin pdj = new PropertyDescriptorJoin(ppd.getName(), ppd.getReadMethod(), ppd.getWriteMethod());
            pdj.setJoinTable(jtable);
            pdj.setValue("relation.name", (Object)pd.getName());
            pdj.setSQLType(BeanManagerUtils.getSQLType(ppd.getPropertyType()));
            result.properties.put(ppd.getName(), (PropertyDescriptor)pdj);
        }
        return pf;
    }

    protected static void processJoinFields(JPAManagedBeanInfo<?> result, String joinTableName, Class<?> superClass, PropertyDescriptor[] properties, List<String> pkList) {
        for (PropertyDescriptor pd : properties) {
            try {
                Transient t;
                if ("class".equals(pd.getName())) continue;
                Field f = null;
                try {
                    f = superClass.getDeclaredField(pd.getName());
                }
                catch (NoSuchFieldException ex) {
                    Log.warn((String)"the field [{0}] doesn't exist!", (Object[])new Object[]{pd.getName()});
                }
                Method m = pd.getReadMethod();
                if (f != null) {
                    t = f.getAnnotation(Transient.class);
                    if (t != null) {
                        Log.debug((String)"the field [{0}] is transient", (Object[])new Object[]{pd.getName()});
                        result.properties.put(pd.getName(), pd);
                        continue;
                    }
                } else {
                    t = m.getAnnotation(Transient.class);
                    if (t != null) {
                        Log.debug((String)"the field [{0}] is transient", (Object[])new Object[]{pd.getName()});
                        result.properties.put(pd.getName(), pd);
                        continue;
                    }
                }
                PropertyDescriptorJoin pdj = new PropertyDescriptorJoin(pd);
                pdj.setJoinTable(joinTableName);
                pdj.setSQLType(BeanManagerUtils.getSQLType(pd.getPropertyType()));
                Id idf = null;
                if (f != null) {
                    idf = f.getAnnotation(Id.class);
                }
                Id idm = m.getAnnotation(Id.class);
                if (idf != null || idm != null) {
                    pkList.add(pdj.getFieldName());
                }
                JPAManagedBeanInfo.processColumn(result, f, (PropertyDescriptorField)pdj);
                JPAManagedBeanInfo.processColumn(result, m, (PropertyDescriptorField)pdj);
                if (!result.properties.containsKey(pd.getName())) {
                    result.properties.put(pd.getName(), (PropertyDescriptor)pdj);
                    continue;
                }
                Log.debug((String)"property {0} is duplicated!", (Object[])new Object[]{pd.getName()});
            }
            catch (SecurityException ex) {
                Log.error((String)"security issue on the field [{0}]", (Throwable)ex, (Object[])new Object[]{pd.getName()});
            }
            catch (Exception ex) {
                Log.error((String)"reflection issue on the field [{0}]", (Throwable)ex, (Object[])new Object[]{pd.getName()});
            }
        }
    }

    protected static PropertyDescriptorPK processId(JPAManagedBeanInfo<?> result, AnnotatedElement f, PropertyDescriptor pd) throws Exception {
        GeneratedValue gv;
        if (pd == null || f == null) {
            return null;
        }
        Id id = f.getAnnotation(Id.class);
        if (id == null) {
            return null;
        }
        PropertyDescriptorPK pk = null;
        if (pd instanceof PropertyDescriptorPK) {
            pk = (PropertyDescriptorPK)pd;
        }
        if (pk == null) {
            pk = new PropertyDescriptorPK(pd);
        }
        if ((gv = f.getAnnotation(GeneratedValue.class)) != null) {
            if (!pd.getPropertyType().equals(String.class)) {
                throw new UnsupportedOperationException("the property annotated as Id must be a String type!");
            }
            pk.setValueGenerator((ValueGenerator)new UUIDValueGenerator());
        }
        return pk;
    }

    protected static void processColumn(JPAManagedBeanInfo<?> result, AnnotatedElement f, PropertyDescriptorField pd) throws Exception {
        boolean nullable;
        String name;
        int len;
        if (pd == null || f == null) {
            return;
        }
        Column annotation = f.getAnnotation(Column.class);
        if (annotation == null) {
            return;
        }
        if (!annotation.insertable() && !annotation.updatable()) {
            pd.setReadOnly(true);
        }
        if ((len = annotation.length()) > 0) {
            pd.setSize(len);
        }
        if ((name = annotation.name()) != null) {
            pd.setFieldName(name);
        }
        if (!(nullable = annotation.nullable())) {
            pd.setRequired(true);
        }
    }

    private static <T> void processFields(JPAManagedBeanInfo<T> result, Class<T> beanClass, PropertyDescriptor[] properties, List<PropertyDescriptorPK> pk) {
        for (PropertyDescriptor pd : properties) {
            try {
                PropertyDescriptor ppd;
                Transient t;
                if ("class".equals(pd.getName())) continue;
                Field f = null;
                try {
                    f = beanClass.getDeclaredField(pd.getName());
                }
                catch (NoSuchFieldException ex) {
                    Log.warn((String)"the field [{0}] doesn't exist!", (Object[])new Object[]{pd.getName()});
                }
                Method m = pd.getReadMethod();
                if (f != null) {
                    t = f.getAnnotation(Transient.class);
                    if (t != null) {
                        Log.debug((String)"the field [{0}] is transient", (Object[])new Object[]{pd.getName()});
                        result.properties.put(pd.getName(), pd);
                        continue;
                    }
                } else {
                    t = m.getAnnotation(Transient.class);
                    if (t != null) {
                        Log.debug((String)"the field [{0}] is transient", (Object[])new Object[]{pd.getName()});
                        result.properties.put(pd.getName(), pd);
                        continue;
                    }
                }
                if (f != null && (ppd = JPAManagedBeanInfo.processJoin(result, f, f.getAnnotation(OneToOne.class), pd)) != null) {
                    result.properties.put(pd.getName(), ppd);
                    continue;
                }
                PropertyDescriptorPK pf = JPAManagedBeanInfo.processId(result, f, pd);
                if (pf == null) {
                    pf = JPAManagedBeanInfo.processId(result, m, pd);
                }
                if (pf != null) {
                    JPAManagedBeanInfo.processColumn(result, f, (PropertyDescriptorField)pf);
                    JPAManagedBeanInfo.processColumn(result, m, (PropertyDescriptorField)pf);
                    pf.setSQLType(BeanManagerUtils.getSQLType(pd.getPropertyType()));
                    result.properties.put(pd.getName(), (PropertyDescriptor)pf);
                    pk.add(pf);
                    continue;
                }
                pf = null;
                if (pd instanceof PropertyDescriptorField) {
                    pf = (PropertyDescriptorField)pd;
                }
                if (pf == null) {
                    pf = new PropertyDescriptorField(pd);
                }
                JPAManagedBeanInfo.processColumn(result, f, (PropertyDescriptorField)pf);
                JPAManagedBeanInfo.processColumn(result, m, (PropertyDescriptorField)pf);
                pf.setSQLType(BeanManagerUtils.getSQLType(pd.getPropertyType()));
                result.properties.put(pd.getName(), (PropertyDescriptor)pf);
            }
            catch (SecurityException ex) {
                Log.error((String)"security issue on the field [{0}]", (Throwable)ex, (Object[])new Object[]{pd.getName()});
            }
            catch (Exception ex) {
                Log.error((String)"reflection issue on the field [{0}]", (Throwable)ex, (Object[])new Object[]{pd.getName()});
            }
        }
    }

    public static <T> JPAManagedBeanInfo<T> create(Class<T> beanClass) throws IntrospectionException {
        BeanInfo beanInfo;
        Entity entity = beanClass.getAnnotation(Entity.class);
        if (entity == null) {
            throw new IllegalArgumentException(String.format("class [%s] is not an Entity!", beanClass.getName()));
        }
        String tableName = beanClass.getSimpleName();
        Table table = beanClass.getAnnotation(Table.class);
        if (table != null) {
            tableName = table.name();
        }
        String joinTableName = null;
        boolean noEntityInheritance = false;
        boolean singleTableInheritance = false;
        boolean joinedInheritance = false;
        boolean mappedSuperclass = false;
        Class<T> superClass = beanClass.getSuperclass();
        if (superClass != null) {
            Entity entity2 = superClass.getAnnotation(Entity.class);
            if (entity2 != null) {
                Inheritance inheritance = superClass.getAnnotation(Inheritance.class);
                if (inheritance == null) {
                    singleTableInheritance = true;
                } else {
                    if (inheritance.strategy() == InheritanceType.TABLE_PER_CLASS) {
                        throw new IllegalStateException(String.format("TABLE_PER_CLASS is not supported yet!", new Object[0]));
                    }
                    if (inheritance.strategy() == InheritanceType.JOINED) {
                        joinedInheritance = true;
                        joinTableName = superClass.getSimpleName();
                        Table table2 = superClass.getAnnotation(Table.class);
                        if (table2 != null) {
                            joinTableName = table2.name();
                        }
                    } else {
                        singleTableInheritance = true;
                    }
                }
            } else {
                MappedSuperclass msc = superClass.getAnnotation(MappedSuperclass.class);
                mappedSuperclass = msc != null;
                noEntityInheritance = msc == null;
            }
        }
        Log.debug((String)"table name [{0}]", (Object[])new Object[]{tableName});
        JPAManagedBeanInfo<T> result = new JPAManagedBeanInfo<T>(beanClass);
        BeanInfo beanInfo2 = beanInfo = joinedInheritance || noEntityInheritance ? Introspector.getBeanInfo(beanClass, superClass) : Introspector.getBeanInfo(beanClass);
        if (null == beanInfo) {
            throw new IllegalStateException("beanInfo not found!");
        }
        result.beanDescriptor = new BeanDescriptorEntity(beanClass, tableName);
        PropertyDescriptor[] pd = beanInfo.getPropertyDescriptors();
        result.properties = new LinkedHashMap<String, PropertyDescriptor>(pd.length);
        LinkedList<PropertyDescriptorPK> pkList = new LinkedList<PropertyDescriptorPK>();
        JPAManagedBeanInfo.processFields(result, beanClass, pd, pkList);
        if (joinedInheritance) {
            BeanInfo joinedBeanInfo = Introspector.getBeanInfo(superClass);
            LinkedList<String> jpkList = new LinkedList<String>();
            JPAManagedBeanInfo.processJoinFields(result, joinTableName, superClass, joinedBeanInfo.getPropertyDescriptors(), jpkList);
            if (pkList.size() != jpkList.size()) {
                throw new IllegalStateException(String.format(" Primary key of table [%s] doesn't match with Pimary Key of joined table [%s]!", tableName, joinTableName));
            }
            for (int i = 0; i < pkList.size(); ++i) {
                result.beanDescriptor.createJoinRelation(joinTableName, new JoinCondition[]{new JoinCondition(((PropertyDescriptorPK)pkList.get(i)).getFieldName(), (String)jpkList.get(i))});
            }
            result.getAdditionalList().add(JPAManagedBeanInfo.create(superClass));
        }
        return result;
    }

    protected JPAManagedBeanInfo(Class<T> beanClass) {
        this.setBeanClass(beanClass);
    }

    protected List<JPAManagedBeanInfo<?>> getAdditionalList() {
        if (this.additionalList == null) {
            this.additionalList = new ArrayList(5);
        }
        return this.additionalList;
    }

    protected <F extends PropertyDescriptorField> F getPropertyField(String name) {
        return (F)((PropertyDescriptorField)this.properties.get(name));
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<? extends T> type) {
        this.beanClass = type;
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties.values().toArray(new PropertyDescriptor[this.properties.size()]);
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        return new EventSetDescriptor[0];
    }

    public int getDefaultEventIndex() {
        return -1;
    }

    public int getDefaultPropertyIndex() {
        return -1;
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return new MethodDescriptor[0];
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        if (this.additionalList == null) {
            return null;
        }
        return this.additionalList.toArray(new BeanInfo[this.additionalList.size()]);
    }

    public Image getIcon(int i) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RelationBeanFactory {
        final Class<?> beanClass;
        final Method setter;

        RelationBeanFactory(Class<?> beanClass, Method setter) {
            if (null == beanClass) {
                throw new IllegalArgumentException("beanClass param is null!");
            }
            if (null == setter) {
                throw new IllegalArgumentException("setter param is null!");
            }
            this.beanClass = beanClass;
            this.setter = setter;
        }

        public void createAndSet(Object bean) throws Exception {
            Log.debug((String)"TRY TO CREATE BEANCLASS [{0}]", (Object[])new Object[]{this.beanClass.getName()});
            Object o = this.beanClass.newInstance();
            Log.debug((String)"INVOKING SETTER [{0}]", (Object[])new Object[]{this.setter.toString()});
            this.setter.invoke(bean, o);
        }
    }
}

