/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.bean.jpa;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import org.bsc.bean.AggregateBeanManager;
import org.bsc.bean.BeanManager;
import org.bsc.bean.ManagedBeanInfo;
import org.bsc.bean.jpa.JPABeanManager;
import org.bsc.bean.jpa.JPAManagedBeanInfo;
import org.bsc.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPABeanManagerFactory {
    public static <T> BeanManager<T> createBeanManager(Class<T> beanClass) {
        try {
            JPAManagedBeanInfo<T> beanInfo = JPAManagedBeanInfo.create(beanClass);
            BeanInfo[] additionalBeanInfo = beanInfo.getAdditionalBeanInfo();
            if (additionalBeanInfo != null && additionalBeanInfo.length > 0) {
                BeanManager[] aggregateBeanManager = new BeanManager[additionalBeanInfo.length];
                for (int i = 0; i < additionalBeanInfo.length; ++i) {
                    aggregateBeanManager[i] = new JPABeanManager((ManagedBeanInfo)additionalBeanInfo[i]);
                }
                return new AggregateBeanManager(new JPABeanManager<T>(beanInfo), aggregateBeanManager);
            }
            return new JPABeanManager<T>(beanInfo);
        }
        catch (IntrospectionException ex) {
            Log.error((String)"error reading metadata from [{0}]", (Throwable)ex, (Object[])new Object[]{beanClass.getName()});
            return null;
        }
    }
}

