/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.bsc.langgraph4j.builder.GraphDefinition;

public class Generator {
    final Mustache customAgentBuilderTemplate;
    final Mustache customAgentBuilderImplTemplate;

    public static void main(String[] args) throws Exception {
        StringBuilder definitionBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
            String line = "";
            while ((line = reader.readLine()) != null) {
                definitionBuilder.append(line).append('\n');
            }
        }
        if (definitionBuilder.isEmpty()) {
            throw new IllegalArgumentException("expected input!");
        }
        Generator gen = new Generator();
        ObjectMapper objectMapperYAML = new ObjectMapper(new YAMLFactory());
        GraphDefinition.Graph graph = objectMapperYAML.readValue(definitionBuilder.toString(), GraphDefinition.Graph.class);
        String stub = gen.generateBuilderFromDefinition(graph);
        String implementation = gen.generateBuilderImplementationFromDefinition(graph);
        Result result = new Result(stub, implementation);
        ObjectMapper objectMapper = new ObjectMapper();
        System.out.println(objectMapper.writeValueAsString(result));
    }

    public Generator() {
        DefaultMustacheFactory factory = new DefaultMustacheFactory(){

            @Override
            public void encode(String value, Writer writer) {
                try {
                    writer.write(value);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        factory.setObjectHandler(new MapMethodReflectionHandler());
        this.customAgentBuilderTemplate = factory.compile("CustomAgentBuilder.mustache");
        this.customAgentBuilderImplTemplate = factory.compile("CustomAgentBuilderImpl.mustache");
    }

    public String generateBuilderFromDefinition(GraphDefinition.Graph graph) throws IOException {
        StringWriter out = new StringWriter();
        this.customAgentBuilderTemplate.execute((Writer)out, graph).flush();
        return out.toString();
    }

    public String generateBuilderImplementationFromDefinition(GraphDefinition.Graph graph) throws IOException {
        StringWriter out = new StringWriter();
        this.customAgentBuilderImplTemplate.execute((Writer)out, graph).flush();
        return out.toString();
    }

    public record Result(String stub, String implementation) {
    }

    private static class MapMethodReflectionHandler
    extends ReflectionObjectHandler {
        private MapMethodReflectionHandler() {
        }

        @Override
        protected boolean areMethodsAccessible(Map<?, ?> map) {
            return true;
        }
    }
}

