/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.builder;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class GraphDefinition {
    private static boolean isStart(String name) {
        return Objects.equals(name, "__start__");
    }

    private static boolean isEnd(String name) {
        return Objects.equals(name, "__end__");
    }

    private static String formatValue(String value) {
        if (value == null) {
            return null;
        }
        if (GraphDefinition.isStart(value)) {
            return "START";
        }
        if (GraphDefinition.isEnd(value)) {
            return "END";
        }
        return String.format("\"%s\"", value);
    }

    private static String formatName(String name) {
        if (name == null) {
            return null;
        }
        return name.replace(' ', '_');
    }

    public record Graph(String name, List<Node> nodes, List<Edge> edges) {
        @JsonCreator
        public Graph(@JsonProperty(value="name") String name, @JsonProperty(value="nodes") List<Node> nodes, @JsonProperty(value="edges") List<Edge> edges) {
            this.name = name;
            this.nodes = Objects.requireNonNull(nodes, "nodes cannot be null");
            this.edges = Objects.requireNonNull(edges, "edges cannot be null");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Edge(String from, String to, String condition, List<String> paths) {
        private final String from;
        private final String to;
        private final String condition;
        private final List<String> paths;

        @JsonCreator
        public Edge(@JsonProperty(value="from") String from, @JsonProperty(value="to") @JsonInclude(value=JsonInclude.Include.NON_NULL) String to, @JsonProperty(value="condition") @JsonInclude(value=JsonInclude.Include.NON_NULL) String condition, @JsonProperty(value="paths") @JsonInclude(value=JsonInclude.Include.NON_NULL) List<String> paths) {
            this.from = Objects.requireNonNull(from, "'from' cannot be null");
            this.to = to;
            this.condition = condition;
            this.paths = paths;
            if (condition == null) {
                if (to == null) {
                    throw new IllegalArgumentException("'to' cannot be null when condition is not specified");
                }
            } else {
                if (paths == null || paths.isEmpty()) {
                    throw new IllegalArgumentException("'paths' cannot be null or empty when condition is specified");
                }
                if (to != null) {
                    throw new IllegalArgumentException("'to' must be null when condition is specified");
                }
            }
        }

        public String from() {
            return GraphDefinition.formatName(this.from);
        }

        public String from$() {
            return GraphDefinition.formatValue(this.from());
        }

        public String to() {
            return GraphDefinition.formatName(this.to);
        }

        public String to$() {
            return GraphDefinition.formatValue(this.to());
        }

        public String condition() {
            if (this.condition == null) {
                return null;
            }
            return GraphDefinition.formatName(this.condition);
        }

        public List<String> paths() {
            if (this.paths == null) {
                return null;
            }
            return this.paths.stream().map(GraphDefinition::formatName).toList();
        }

        public List<String> paths$() {
            if (this.paths() == null) {
                return null;
            }
            return this.paths().stream().map(GraphDefinition::formatValue).toList();
        }
    }

    public record Node(String name) {
        private final String name;

        @JsonCreator
        public Node(@JsonProperty(value="name") String name) {
            this.name = Objects.requireNonNull(name, "name cannot be null");
        }

        public String name() {
            return GraphDefinition.formatName(this.name);
        }

        public String name$() {
            return GraphDefinition.formatValue(this.name);
        }
    }
}

