/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.retriever.WebSearchContentRetriever;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.tavily.TavilyWebSearchEngine;
import java.util.List;
import java.util.function.Function;

public final class WebSearchTool
implements Function<String, List<Content>> {
    private final String tavilyApiKey;

    @Override
    public List<Content> apply(String query) {
        TavilyWebSearchEngine webSearchEngine = TavilyWebSearchEngine.builder().apiKey(this.tavilyApiKey).build();
        WebSearchContentRetriever webSearchContentRetriever = WebSearchContentRetriever.builder().webSearchEngine((WebSearchEngine)webSearchEngine).maxResults(Integer.valueOf(3)).build();
        return webSearchContentRetriever.retrieve(new Query(query));
    }

    private WebSearchTool(String tavilyApiKey) {
        this.tavilyApiKey = tavilyApiKey;
    }

    public static WebSearchTool of(String tavilyApiKey) {
        return new WebSearchTool(tavilyApiKey);
    }

    public String getTavilyApiKey() {
        return this.tavilyApiKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSearchTool)) {
            return false;
        }
        WebSearchTool other = (WebSearchTool)o;
        String this$tavilyApiKey = this.getTavilyApiKey();
        String other$tavilyApiKey = other.getTavilyApiKey();
        return !(this$tavilyApiKey == null ? other$tavilyApiKey != null : !this$tavilyApiKey.equals(other$tavilyApiKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tavilyApiKey = this.getTavilyApiKey();
        result = result * 59 + ($tavilyApiKey == null ? 43 : $tavilyApiKey.hashCode());
        return result;
    }

    public String toString() {
        return "WebSearchTool(tavilyApiKey=" + this.getTavilyApiKey() + ")";
    }
}

