/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.chroma.ChromaEmbeddingStore;
import java.time.Duration;

public final class ChromaStore {
    private final ChromaEmbeddingStore chroma = new ChromaEmbeddingStore("http://localhost:8000", "rag-chroma", Duration.ofMinutes(2L), true, true);
    private final OpenAiEmbeddingModel embeddingModel;

    public static ChromaStore of(String openApiKey) {
        return new ChromaStore(openApiKey);
    }

    private ChromaStore(String openApiKey) {
        this.embeddingModel = OpenAiEmbeddingModel.builder().apiKey(openApiKey).build();
    }

    public EmbeddingSearchResult<TextSegment> search(String query) {
        Embedding queryEmbedding = (Embedding)this.embeddingModel.embed(query).content();
        EmbeddingSearchRequest searchRequest = EmbeddingSearchRequest.builder().queryEmbedding(queryEmbedding).maxResults(Integer.valueOf(1)).minScore(Double.valueOf(0.0)).build();
        return this.chroma.search(searchRequest);
    }
}

