/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.SystemMessage;
import java.time.Duration;
import java.util.function.Function;

public final class RetrievalGrader
implements Function<Arguments, Score> {
    private final String openApiKey;

    @Override
    public Score apply(Arguments args) {
        OpenAiChatModel chatLanguageModel = OpenAiChatModel.builder().apiKey(this.openApiKey).modelName("gpt-3.5-turbo-0125").timeout(Duration.ofMinutes(2L)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
        Service service = (Service)AiServices.create(Service.class, (ChatLanguageModel)chatLanguageModel);
        Prompt prompt = StructuredPromptProcessor.toPrompt((Object)args);
        return service.invoke(prompt.text());
    }

    private RetrievalGrader(String openApiKey) {
        this.openApiKey = openApiKey;
    }

    public static RetrievalGrader of(String openApiKey) {
        return new RetrievalGrader(openApiKey);
    }

    public String getOpenApiKey() {
        return this.openApiKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetrievalGrader)) {
            return false;
        }
        RetrievalGrader other = (RetrievalGrader)o;
        String this$openApiKey = this.getOpenApiKey();
        String other$openApiKey = other.getOpenApiKey();
        return !(this$openApiKey == null ? other$openApiKey != null : !this$openApiKey.equals(other$openApiKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $openApiKey = this.getOpenApiKey();
        result = result * 59 + ($openApiKey == null ? 43 : $openApiKey.hashCode());
        return result;
    }

    public String toString() {
        return "RetrievalGrader(openApiKey=" + this.getOpenApiKey() + ")";
    }

    static interface Service {
        @SystemMessage(value={"You are a grader assessing relevance of a retrieved document to a user question. \n    If the document contains keyword(s) or semantic meaning related to the user question, grade it as relevant. \n    It does not need to be a stringent test. The goal is to filter out erroneous retrievals. \n    Give a binary score 'yes' or 'no' score to indicate whether the document is relevant to the question."})
        public Score invoke(String var1);
    }

    @StructuredPrompt(value={"Retrieved document: \n\n {{document}} \n\n User question: {{question}}"})
    public static final class Arguments {
        private final String question;
        private final String document;

        private Arguments(String question, String document) {
            this.question = question;
            this.document = document;
        }

        public static Arguments of(String question, String document) {
            return new Arguments(question, document);
        }

        public String getQuestion() {
            return this.question;
        }

        public String getDocument() {
            return this.document;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Arguments)) {
                return false;
            }
            Arguments other = (Arguments)o;
            String this$question = this.getQuestion();
            String other$question = other.getQuestion();
            if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
                return false;
            }
            String this$document = this.getDocument();
            String other$document = other.getDocument();
            return !(this$document == null ? other$document != null : !this$document.equals(other$document));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $question = this.getQuestion();
            result = result * 59 + ($question == null ? 43 : $question.hashCode());
            String $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : $document.hashCode());
            return result;
        }

        public String toString() {
            return "RetrievalGrader.Arguments(question=" + this.getQuestion() + ", document=" + this.getDocument() + ")";
        }
    }

    public static class Score {
        @Description(value={"Documents are relevant to the question, 'yes' or 'no'"})
        public String binaryScore;
    }
}

