/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.SystemMessage;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;

public final class HallucinationGrader
implements Function<Arguments, Score> {
    private final String openApiKey;

    @Override
    public Score apply(Arguments args) {
        OpenAiChatModel chatLanguageModel = OpenAiChatModel.builder().apiKey(this.openApiKey).modelName("gpt-3.5-turbo-0125").timeout(Duration.ofMinutes(2L)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
        Service grader = (Service)AiServices.create(Service.class, (ChatLanguageModel)chatLanguageModel);
        Prompt prompt = StructuredPromptProcessor.toPrompt((Object)args);
        return grader.invoke(prompt.text());
    }

    private HallucinationGrader(String openApiKey) {
        this.openApiKey = openApiKey;
    }

    public static HallucinationGrader of(String openApiKey) {
        return new HallucinationGrader(openApiKey);
    }

    public String getOpenApiKey() {
        return this.openApiKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HallucinationGrader)) {
            return false;
        }
        HallucinationGrader other = (HallucinationGrader)o;
        String this$openApiKey = this.getOpenApiKey();
        String other$openApiKey = other.getOpenApiKey();
        return !(this$openApiKey == null ? other$openApiKey != null : !this$openApiKey.equals(other$openApiKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $openApiKey = this.getOpenApiKey();
        result = result * 59 + ($openApiKey == null ? 43 : $openApiKey.hashCode());
        return result;
    }

    public String toString() {
        return "HallucinationGrader(openApiKey=" + this.getOpenApiKey() + ")";
    }

    static interface Service {
        @SystemMessage(value={"You are a grader assessing whether an LLM generation is grounded in / supported by a set of retrieved facts. \nGive a binary score 'yes' or 'no'. 'Yes' means that the answer is grounded in / supported by the set of facts."})
        public Score invoke(String var1);
    }

    public static class Score {
        @Description(value={"Answer is grounded in the facts, 'yes' or 'no'"})
        public String binaryScore;
    }

    @StructuredPrompt(value={"Set of facts: \\n\\n {{documents}} \\n\\n LLM generation: {{generation}}"})
    public static final class Arguments {
        private final List<String> documents;
        private final String generation;

        private Arguments(List<String> documents, String generation) {
            this.documents = documents;
            this.generation = generation;
        }

        public static Arguments of(List<String> documents, String generation) {
            return new Arguments(documents, generation);
        }

        public List<String> getDocuments() {
            return this.documents;
        }

        public String getGeneration() {
            return this.generation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Arguments)) {
                return false;
            }
            Arguments other = (Arguments)o;
            List<String> this$documents = this.getDocuments();
            List<String> other$documents = other.getDocuments();
            if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
                return false;
            }
            String this$generation = this.getGeneration();
            String other$generation = other.getGeneration();
            return !(this$generation == null ? other$generation != null : !this$generation.equals(other$generation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $documents = this.getDocuments();
            result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
            String $generation = this.getGeneration();
            result = result * 59 + ($generation == null ? 43 : $generation.hashCode());
            return result;
        }

        public String toString() {
            return "HallucinationGrader.Arguments(documents=" + this.getDocuments() + ", generation=" + this.getGeneration() + ")";
        }
    }
}

