/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.SystemMessage;
import java.time.Duration;
import java.util.function.Function;

public final class AnswerGrader
implements Function<Arguments, Score> {
    private final String openApiKey;

    @Override
    public Score apply(Arguments args) {
        OpenAiChatModel chatLanguageModel = OpenAiChatModel.builder().apiKey(this.openApiKey).modelName("gpt-3.5-turbo-0125").timeout(Duration.ofMinutes(2L)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
        Service service = (Service)AiServices.create(Service.class, (ChatLanguageModel)chatLanguageModel);
        Prompt prompt = StructuredPromptProcessor.toPrompt((Object)args);
        return service.invoke(prompt.text());
    }

    private AnswerGrader(String openApiKey) {
        this.openApiKey = openApiKey;
    }

    public static AnswerGrader of(String openApiKey) {
        return new AnswerGrader(openApiKey);
    }

    public String getOpenApiKey() {
        return this.openApiKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerGrader)) {
            return false;
        }
        AnswerGrader other = (AnswerGrader)o;
        String this$openApiKey = this.getOpenApiKey();
        String other$openApiKey = other.getOpenApiKey();
        return !(this$openApiKey == null ? other$openApiKey != null : !this$openApiKey.equals(other$openApiKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $openApiKey = this.getOpenApiKey();
        result = result * 59 + ($openApiKey == null ? 43 : $openApiKey.hashCode());
        return result;
    }

    public String toString() {
        return "AnswerGrader(openApiKey=" + this.getOpenApiKey() + ")";
    }

    static interface Service {
        @SystemMessage(value={"You are a grader assessing whether an answer addresses and/or resolves a question. \n\nGive a binary score 'yes' or 'no'. Yes, means that the answer resolves the question otherwise return 'no'"})
        public Score invoke(String var1);
    }

    public static class Score {
        @Description(value={"Answer addresses the question, 'yes' or 'no'"})
        public String binaryScore;
    }

    @StructuredPrompt(value={"User question: \n\n {{question}} \n\n LLM generation: {{generation}}"})
    public static final class Arguments {
        private final String question;
        private final String generation;

        private Arguments(String question, String generation) {
            this.question = question;
            this.generation = generation;
        }

        public static Arguments of(String question, String generation) {
            return new Arguments(question, generation);
        }

        public String getQuestion() {
            return this.question;
        }

        public String getGeneration() {
            return this.generation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Arguments)) {
                return false;
            }
            Arguments other = (Arguments)o;
            String this$question = this.getQuestion();
            String other$question = other.getQuestion();
            if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
                return false;
            }
            String this$generation = this.getGeneration();
            String other$generation = other.getGeneration();
            return !(this$generation == null ? other$generation != null : !this$generation.equals(other$generation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $question = this.getQuestion();
            result = result * 59 + ($question == null ? 43 : $question.hashCode());
            String $generation = this.getGeneration();
            result = result * 59 + ($generation == null ? 43 : $generation.hashCode());
            return result;
        }

        public String toString() {
            return "AnswerGrader.Arguments(question=" + this.getQuestion() + ", generation=" + this.getGeneration() + ")";
        }
    }
}

