/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.SystemMessage;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;

public final class QuestionRewriter
implements Function<String, String> {
    private final String openApiKey;

    @Override
    public String apply(String question) {
        OpenAiChatModel chatLanguageModel = OpenAiChatModel.builder().apiKey(this.openApiKey).modelName("gpt-3.5-turbo-0125").timeout(Duration.ofMinutes(2L)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
        LLMService service = (LLMService)AiServices.create(LLMService.class, (ChatLanguageModel)chatLanguageModel);
        PromptTemplate template = PromptTemplate.from((String)"Here is the initial question: \n\n {{question}} \n Formulate an improved question.");
        Prompt prompt = template.apply(Map.of("question", question));
        return service.invoke(prompt.text());
    }

    private QuestionRewriter(String openApiKey) {
        this.openApiKey = openApiKey;
    }

    public static QuestionRewriter of(String openApiKey) {
        return new QuestionRewriter(openApiKey);
    }

    public String getOpenApiKey() {
        return this.openApiKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuestionRewriter)) {
            return false;
        }
        QuestionRewriter other = (QuestionRewriter)o;
        String this$openApiKey = this.getOpenApiKey();
        String other$openApiKey = other.getOpenApiKey();
        return !(this$openApiKey == null ? other$openApiKey != null : !this$openApiKey.equals(other$openApiKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $openApiKey = this.getOpenApiKey();
        result = result * 59 + ($openApiKey == null ? 43 : $openApiKey.hashCode());
        return result;
    }

    public String toString() {
        return "QuestionRewriter(openApiKey=" + this.getOpenApiKey() + ")";
    }

    static interface LLMService {
        @SystemMessage(value={"You a question re-writer that converts an input question to a better version that is optimized \nfor vectorstore retrieval. Look at the input and try to reason about the underlying semantic intent / meaning."})
        public String invoke(String var1);
    }
}

