/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.SystemMessage;
import java.time.Duration;
import java.util.function.Function;

public record QuestionRouter(String openApiKey) implements Function<String, Type>
{
    @Override
    public Type apply(String question) {
        OpenAiChatModel chatLanguageModel = OpenAiChatModel.builder().apiKey(this.openApiKey).modelName("gpt-3.5-turbo-0125").timeout(Duration.ofMinutes(2L)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
        Service extractor = (Service)AiServices.create(Service.class, (ChatModel)chatLanguageModel);
        Result ds = extractor.invoke(question);
        return ds.datasource;
    }

    static interface Service {
        @SystemMessage(value={"You are an expert at routing a user question to a vectorstore or web search.\nThe vectorstore contains documents related to agents, prompt engineering, and adversarial attacks.\nUse the vectorstore for questions on these topics. Otherwise, use web-search."})
        public Result invoke(String var1);
    }

    static class Result {
        @Description(value={"Given a user question choose to route it to web search or a vectorstore."})
        Type datasource;

        Result() {
        }
    }

    public static enum Type {
        vectorstore,
        web_search;

    }
}

