/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.SystemMessage;
import java.time.Duration;
import java.util.function.Function;

public record AnswerGrader(String openApiKey) implements Function<Arguments, Score>
{
    @Override
    public Score apply(Arguments args) {
        OpenAiChatModel chatLanguageModel = OpenAiChatModel.builder().apiKey(this.openApiKey).modelName("gpt-3.5-turbo-0125").timeout(Duration.ofMinutes(2L)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
        Service service = (Service)AiServices.create(Service.class, (ChatModel)chatLanguageModel);
        Prompt prompt = StructuredPromptProcessor.toPrompt((Object)args);
        return service.invoke(prompt.text());
    }

    static interface Service {
        @SystemMessage(value={"You are a grader assessing whether an answer addresses and/or resolves a question. \n\nGive a binary score 'yes' or 'no'. Yes, means that the answer resolves the question otherwise return 'no'"})
        public Score invoke(String var1);
    }

    public static class Score {
        @Description(value={"Answer addresses the question, 'yes' or 'no'"})
        public String binaryScore;
    }

    @StructuredPrompt(value={"User question: \n\n {{question}} \n\n LLM generation: {{generation}}"})
    public record Arguments(String question, String generation) {
    }
}

