/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.UserMessage;
import dev.langchain4j.service.V;
import java.time.Duration;
import java.util.List;
import java.util.function.BiFunction;

public record Generation(String openApiKey) implements BiFunction<String, List<String>, String>
{
    @Override
    public String apply(String question, List<String> context) {
        OpenAiChatModel chatLanguageModel = OpenAiChatModel.builder().apiKey(this.openApiKey).modelName("gpt-3.5-turbo").timeout(Duration.ofMinutes(2L)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
        Service service = (Service)AiServices.create(Service.class, (ChatModel)chatLanguageModel);
        return service.invoke(question, context);
    }

    public static interface Service {
        @UserMessage(value={"You are an assistant for question-answering tasks. Use the following pieces of retrieved context to answer the question. If you don't know the answer, just say that you don't know. Use three sentences maximum and keep the answer concise.\nQuestion: {{question}} \nContext: {{context}} \nAnswer:"})
        public String invoke(@V(value="question") String var1, @V(value="context") List<String> var2);
    }
}

