/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.SystemMessage;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;

public record QuestionRewriter(String openApiKey) implements Function<String, String>
{
    @Override
    public String apply(String question) {
        OpenAiChatModel chatLanguageModel = OpenAiChatModel.builder().apiKey(this.openApiKey).modelName("gpt-3.5-turbo-0125").timeout(Duration.ofMinutes(2L)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
        LLMService service = (LLMService)AiServices.create(LLMService.class, (ChatModel)chatLanguageModel);
        PromptTemplate template = PromptTemplate.from((String)"Here is the initial question: \n\n {{question}} \n Formulate an improved question.");
        Prompt prompt = template.apply(Map.of("question", question));
        return service.invoke(prompt.text());
    }

    static interface LLMService {
        @SystemMessage(value={"You a question re-writer that converts an input question to a better version that is optimized \nfor vectorstore retrieval. Look at the input and try to reason about the underlying semantic intent / meaning."})
        public String invoke(String var1);
    }
}

