/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.adaptiverag;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.SystemMessage;
import java.time.Duration;
import java.util.function.Function;

public record RetrievalGrader(String openApiKey) implements Function<Arguments, Score>
{
    @Override
    public Score apply(Arguments args) {
        OpenAiChatModel chatLanguageModel = OpenAiChatModel.builder().apiKey(this.openApiKey).modelName("gpt-3.5-turbo-0125").timeout(Duration.ofMinutes(2L)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
        Service service = (Service)AiServices.create(Service.class, (ChatModel)chatLanguageModel);
        Prompt prompt = StructuredPromptProcessor.toPrompt((Object)args);
        return service.invoke(prompt.text());
    }

    static interface Service {
        @SystemMessage(value={"You are a grader assessing relevance of a retrieved document to a user question. \n    If the document contains keyword(s) or semantic meaning related to the user question, grade it as relevant. \n    It does not need to be a stringent test. The goal is to filter out erroneous retrievals. \n    Give a binary score 'yes' or 'no' score to indicate whether the document is relevant to the question."})
        public Score invoke(String var1);
    }

    public static class Score {
        @Description(value={"Documents are relevant to the question, 'yes' or 'no'"})
        public String binaryScore;
    }

    @StructuredPrompt(value={"Retrieved document: \n\n {{document}} \n\n User question: {{question}}"})
    public record Arguments(String question, String document) {
    }
}

