/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor.serializer.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import lombok.NonNull;
import org.bsc.langgraph4j.agentexecutor.AgentAction;
import org.bsc.langgraph4j.agentexecutor.AgentExecutor;
import org.bsc.langgraph4j.agentexecutor.AgentFinish;
import org.bsc.langgraph4j.agentexecutor.AgentOutcome;
import org.bsc.langgraph4j.agentexecutor.IntermediateStep;
import org.bsc.langgraph4j.agentexecutor.serializer.json.AgentActionDeserializer;
import org.bsc.langgraph4j.agentexecutor.serializer.json.AgentFinishDeserializer;
import org.bsc.langgraph4j.agentexecutor.serializer.json.AgentOutcomeDeserializer;
import org.bsc.langgraph4j.agentexecutor.serializer.json.IntermediateStepDeserializer;
import org.bsc.langgraph4j.agentexecutor.serializer.json.StateDeserializer;
import org.bsc.langgraph4j.agentexecutor.serializer.json.ToolExecutionRequestDeserializer;
import org.bsc.langgraph4j.serializer.plain_text.PlainTextStateSerializer;

public class JSONStateSerializer
extends PlainTextStateSerializer<AgentExecutor.State> {
    final ObjectMapper objectMapper;

    public JSONStateSerializer() {
        this(new ObjectMapper());
    }

    public JSONStateSerializer(@NonNull ObjectMapper objectMapper) {
        super(AgentExecutor.State::new);
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(AgentExecutor.State.class, (JsonDeserializer)new StateDeserializer());
        module.addDeserializer(AgentOutcome.class, (JsonDeserializer)new AgentOutcomeDeserializer());
        module.addDeserializer(AgentAction.class, (JsonDeserializer)new AgentActionDeserializer());
        module.addDeserializer(AgentFinish.class, (JsonDeserializer)new AgentFinishDeserializer());
        module.addDeserializer(ToolExecutionRequest.class, (JsonDeserializer)new ToolExecutionRequestDeserializer());
        module.addDeserializer(IntermediateStep.class, (JsonDeserializer)new IntermediateStepDeserializer());
        objectMapper.registerModule((Module)module);
    }

    public String mimeType() {
        return "application/json";
    }

    public void write(AgentExecutor.State object, ObjectOutput out) throws IOException {
        String json = this.objectMapper.writeValueAsString((Object)object);
        out.writeUTF(json);
    }

    public AgentExecutor.State read(ObjectInput in) throws IOException, ClassNotFoundException {
        String json = in.readUTF();
        return (AgentExecutor.State)((Object)this.objectMapper.readValue(json, AgentExecutor.State.class));
    }
}

