/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor.serializer.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.bsc.langgraph4j.agentexecutor.AgentExecutor;
import org.bsc.langgraph4j.agentexecutor.AgentOutcome;
import org.bsc.langgraph4j.agentexecutor.IntermediateStep;

class StateDeserializer
extends JsonDeserializer<AgentExecutor.State> {
    StateDeserializer() {
    }

    public AgentExecutor.State deserialize(JsonParser parser, DeserializationContext ctx) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        HashMap<String, Object> data = new HashMap<String, Object>();
        JsonNode dataNode = node.has("data") ? node.get("data") : node;
        data.put("input", dataNode.get("input").asText());
        JsonNode intermediateStepsNode = dataNode.get("intermediate_steps");
        if (intermediateStepsNode == null || intermediateStepsNode.isNull()) {
            throw new IOException("intermediate_steps must not be null!");
        }
        if (!intermediateStepsNode.isArray()) {
            throw new IOException("intermediate_steps must be an array!");
        }
        ArrayList<IntermediateStep> intermediateStepList = new ArrayList<IntermediateStep>();
        for (JsonNode intermediateStepNode : intermediateStepsNode) {
            IntermediateStep intermediateStep = (IntermediateStep)ctx.readValue(intermediateStepNode.traverse(parser.getCodec()), IntermediateStep.class);
            intermediateStepList.add(intermediateStep);
        }
        data.put("intermediate_steps", intermediateStepList);
        JsonNode agentOutcomeNode = dataNode.get("agent_outcome");
        if (agentOutcomeNode != null && !agentOutcomeNode.isNull()) {
            AgentOutcome agentOutcome = (AgentOutcome)ctx.readValue(agentOutcomeNode.traverse(parser.getCodec()), AgentOutcome.class);
            data.put("agent_outcome", agentOutcome);
        }
        return new AgentExecutor.State(data);
    }
}

