/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor.actions;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import java.util.List;
import java.util.Map;
import org.bsc.langgraph4j.action.NodeAction;
import org.bsc.langgraph4j.agentexecutor.Agent;
import org.bsc.langgraph4j.agentexecutor.AgentExecutor;
import org.bsc.langgraph4j.agentexecutor.state.AgentAction;
import org.bsc.langgraph4j.agentexecutor.state.AgentFinish;
import org.bsc.langgraph4j.agentexecutor.state.AgentOutcome;
import org.bsc.langgraph4j.agentexecutor.state.IntermediateStep;
import org.bsc.langgraph4j.langchain4j.generators.LLMStreamingGenerator;
import org.bsc.langgraph4j.state.AgentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallAgent
implements NodeAction<AgentExecutor.State> {
    private static final Logger log = LoggerFactory.getLogger(CallAgent.class);
    final Agent agent;

    public CallAgent(Agent agent) {
        this.agent = agent;
    }

    private Map<String, Object> mapResult(Response<AiMessage> response) {
        AiMessage content = (AiMessage)response.content();
        if (response.finishReason() == FinishReason.STOP) {
            String result = content.text();
            AgentFinish finish = new AgentFinish(Map.of("returnValues", result), result);
            return Map.of("agent_outcome", new AgentOutcome(null, finish));
        }
        if (response.finishReason() == FinishReason.TOOL_EXECUTION || ((AiMessage)response.content()).hasToolExecutionRequests()) {
            List toolExecutionRequests = ((AiMessage)response.content()).toolExecutionRequests();
            AgentAction action = new AgentAction((ToolExecutionRequest)toolExecutionRequests.get(0), "");
            return Map.of("agent_outcome", new AgentOutcome(action, null));
        }
        throw new IllegalStateException("Unsupported finish reason: " + String.valueOf(response.finishReason()));
    }

    public Map<String, Object> apply(AgentExecutor.State state) {
        log.trace("callAgent");
        String input = state.input().orElseThrow(() -> new IllegalArgumentException("no input provided!"));
        List<IntermediateStep> intermediateSteps = state.intermediateSteps();
        if (this.agent.isStreaming()) {
            LLMStreamingGenerator generator = LLMStreamingGenerator.builder().mapResult(this::mapResult).startingNode("agent").startingState((AgentState)state).build();
            this.agent.execute(input, intermediateSteps, (StreamingResponseHandler<AiMessage>)generator.handler());
            return Map.of("agent_outcome", generator);
        }
        Response<AiMessage> response = this.agent.execute(input, intermediateSteps);
        return this.mapResult(response);
    }
}

