/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor.actions;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.bsc.langgraph4j.action.NodeAction;
import org.bsc.langgraph4j.agentexecutor.Agent;
import org.bsc.langgraph4j.agentexecutor.AgentExecutor;
import org.bsc.langgraph4j.agentexecutor.state.AgentAction;
import org.bsc.langgraph4j.agentexecutor.state.AgentOutcome;
import org.bsc.langgraph4j.agentexecutor.state.IntermediateStep;
import org.bsc.langgraph4j.langchain4j.tool.ToolNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTools
implements NodeAction<AgentExecutor.State> {
    private static final Logger log = LoggerFactory.getLogger(ExecuteTools.class);
    final Agent agent;
    final ToolNode toolNode;

    public ExecuteTools(@NonNull Agent agent, @NonNull ToolNode toolNode) {
        if (agent == null) {
            throw new NullPointerException("agent is marked non-null but is null");
        }
        if (toolNode == null) {
            throw new NullPointerException("toolNode is marked non-null but is null");
        }
        this.agent = agent;
        this.toolNode = toolNode;
    }

    public Map<String, Object> apply(AgentExecutor.State state) {
        log.trace("executeTools");
        AgentOutcome agentOutcome = state.agentOutcome().orElseThrow(() -> new IllegalArgumentException("no agentOutcome provided!"));
        ToolExecutionRequest toolExecutionRequest = Optional.ofNullable(agentOutcome.action()).map(AgentAction::toolExecutionRequest).orElseThrow(() -> new IllegalStateException("no action provided!"));
        String result = this.toolNode.execute(toolExecutionRequest).map(ToolExecutionResultMessage::text).orElseThrow(() -> new IllegalStateException("no tool found for: " + toolExecutionRequest.name()));
        return Map.of("intermediate_steps", new IntermediateStep(agentOutcome.action(), result));
    }
}

