/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor.serializer.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bsc.langgraph4j.agentexecutor.state.AgentFinish;

class AgentFinishDeserializer
extends JsonDeserializer<AgentFinish> {
    AgentFinishDeserializer() {
    }

    public AgentFinish deserialize(JsonParser parser, DeserializationContext ctx) throws IOException, JacksonException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        String log = node.get("log").asText();
        JsonNode returnValuesNode = node.get("returnValues");
        if (returnValuesNode == null || returnValuesNode.isNull()) {
            return new AgentFinish(null, log);
        }
        if (returnValuesNode.isObject()) {
            HashMap<String, Object> returnValues = new HashMap<String, Object>();
            Iterator entries = returnValuesNode.fields();
            while (entries.hasNext()) {
                Map.Entry entry = (Map.Entry)entries.next();
                returnValues.put((String)entry.getKey(), entry.getValue());
            }
            return new AgentFinish(returnValues, log);
        }
        throw new IOException("Unsupported return values Node: " + String.valueOf(returnValuesNode.getNodeType()));
    }
}

