/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j;

import org.bsc.langgraph4j.EdgeCondition;
import org.bsc.langgraph4j.EdgeValue;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.state.AgentState;

public abstract class DiagramGenerator {
    protected abstract void appendHeader(StringBuilder var1, String var2);

    protected abstract void appendFooter(StringBuilder var1);

    protected abstract void start(StringBuilder var1, String var2);

    protected abstract void finish(StringBuilder var1, String var2);

    protected abstract void finish(StringBuilder var1, String var2, String var3);

    protected abstract void call(StringBuilder var1, String var2, String var3);

    protected abstract void call(StringBuilder var1, String var2, String var3, String var4);

    protected abstract void declareConditionalStart(StringBuilder var1, String var2);

    protected abstract void declareNode(StringBuilder var1, String var2);

    protected abstract void declareConditionalEdge(StringBuilder var1, int var2);

    protected abstract StringBuilder commentLine(StringBuilder var1, boolean var2);

    public final <State extends AgentState> String generate(StateGraph<State> compiledGraph, String title, boolean printConditionalEdge) {
        StringBuilder sb = new StringBuilder();
        this.appendHeader(sb, title);
        compiledGraph.nodes.forEach(s -> this.declareNode(sb, s.id()));
        int[] conditionalEdgeCount = new int[]{0};
        compiledGraph.edges.forEach(e -> {
            if (e.target().value() != null) {
                conditionalEdgeCount[0] = conditionalEdgeCount[0] + 1;
                this.declareConditionalEdge(this.commentLine(sb, !printConditionalEdge), conditionalEdgeCount[0]);
            }
        });
        EdgeValue<State> entryPoint = compiledGraph.getEntryPoint();
        if (entryPoint.id() != null) {
            this.start(sb, entryPoint.id());
        } else if (entryPoint.value() != null) {
            String conditionName = "startcondition";
            this.declareConditionalStart(this.commentLine(sb, !printConditionalEdge), conditionName);
            this.edgeCondition(sb, entryPoint.value(), StateGraph.START, conditionName, printConditionalEdge);
        }
        conditionalEdgeCount[0] = 0;
        compiledGraph.edges.forEach(v -> {
            if (v.target().id() != null) {
                this.call(sb, v.sourceId(), v.target().id());
            } else if (v.target().value() != null) {
                conditionalEdgeCount[0] = conditionalEdgeCount[0] + 1;
                String conditionName = String.format("condition%d", conditionalEdgeCount[0]);
                this.edgeCondition(sb, v.target().value(), v.sourceId(), conditionName, printConditionalEdge);
            }
        });
        if (compiledGraph.getFinishPoint() != null) {
            this.finish(sb, compiledGraph.getFinishPoint());
        }
        this.appendFooter(sb);
        return sb.toString();
    }

    private <State extends AgentState> void edgeCondition(StringBuilder sb, EdgeCondition<State> condition, String k, String conditionName, boolean printConditionalEdge) {
        this.call(this.commentLine(sb, !printConditionalEdge), k, conditionName);
        condition.mappings().forEach((cond, to) -> {
            if (to.equals(StateGraph.END)) {
                this.finish(this.commentLine(sb, !printConditionalEdge), conditionName, (String)cond);
                this.finish(this.commentLine(sb, printConditionalEdge), k, (String)cond);
            } else {
                this.call(this.commentLine(sb, !printConditionalEdge), conditionName, (String)to, (String)cond);
                this.call(this.commentLine(sb, printConditionalEdge), k, (String)to, (String)cond);
            }
        });
    }
}

