/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j;

import java.util.Objects;
import java.util.Optional;
import org.bsc.langgraph4j.CompiledGraph;

public final class RunnableConfig {
    private String threadId;
    private String checkPointId;
    private String nextNode;
    private CompiledGraph.StreamMode streamMode = CompiledGraph.StreamMode.VALUES;

    public CompiledGraph.StreamMode streamMode() {
        return this.streamMode;
    }

    public Optional<String> threadId() {
        return Optional.ofNullable(this.threadId);
    }

    public Optional<String> checkPointId() {
        return Optional.ofNullable(this.checkPointId);
    }

    public Optional<String> nextNode() {
        return Optional.ofNullable(this.nextNode);
    }

    public RunnableConfig withStreamMode(CompiledGraph.StreamMode streamMode) {
        if (this.streamMode == streamMode) {
            return this;
        }
        RunnableConfig newConfig = new RunnableConfig(this);
        newConfig.streamMode = streamMode;
        return newConfig;
    }

    public RunnableConfig withCheckPointId(String checkPointId) {
        if (Objects.equals(this.checkPointId, checkPointId)) {
            return this;
        }
        RunnableConfig newConfig = new RunnableConfig(this);
        newConfig.checkPointId = checkPointId;
        return newConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RunnableConfig config) {
        return new Builder(config);
    }

    private RunnableConfig(RunnableConfig config) {
        Objects.requireNonNull(config, "config cannot be null");
        this.threadId = config.threadId;
        this.checkPointId = config.checkPointId;
        this.nextNode = config.nextNode;
        this.streamMode = config.streamMode;
    }

    private RunnableConfig() {
    }

    public String toString() {
        return "RunnableConfig(threadId=" + this.threadId + ", checkPointId=" + this.checkPointId + ", nextNode=" + this.nextNode + ", streamMode=" + (Object)((Object)this.streamMode) + ")";
    }

    public static class Builder {
        private final RunnableConfig config;

        Builder() {
            this.config = new RunnableConfig();
        }

        Builder(RunnableConfig config) {
            this.config = new RunnableConfig(config);
        }

        public Builder threadId(String threadId) {
            this.config.threadId = threadId;
            return this;
        }

        public Builder checkPointId(String checkPointId) {
            this.config.checkPointId = checkPointId;
            return this;
        }

        public Builder nextNode(String nextNode) {
            this.config.nextNode = nextNode;
            return this;
        }

        public Builder streamMode(CompiledGraph.StreamMode streamMode) {
            this.config.streamMode = streamMode;
            return this;
        }

        public RunnableConfig build() {
            return this.config;
        }
    }
}

