/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.checkpoint;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.bsc.langgraph4j.checkpoint.Checkpoint;
import org.bsc.langgraph4j.serializer.StateSerializer;
import org.bsc.langgraph4j.serializer.std.NullableObjectSerializer;
import org.bsc.langgraph4j.state.AgentState;

class CheckPointSerializer
implements NullableObjectSerializer<Checkpoint> {
    final StateSerializer<AgentState> stateSerializer;

    public CheckPointSerializer(StateSerializer<AgentState> stateSerializer) {
        this.stateSerializer = stateSerializer;
    }

    @Override
    public void write(Checkpoint object, ObjectOutput out) throws IOException {
        out.writeUTF(object.getId());
        this.writeNullableUTF(object.getNodeId(), out);
        this.writeNullableUTF(object.getNextNodeId(), out);
        AgentState state = (AgentState)this.stateSerializer.stateFactory().apply(object.getState());
        this.stateSerializer.write(state, out);
    }

    @Override
    public Checkpoint read(ObjectInput in) throws IOException, ClassNotFoundException {
        return Checkpoint.builder().id(in.readUTF()).nextNodeId(this.readNullableUTF(in).orElse(null)).nodeId(this.readNullableUTF(in).orElse(null)).state((AgentState)this.stateSerializer.read(in)).build();
    }
}

