/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.checkpoint;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.Channel;

public class Checkpoint {
    private String id = UUID.randomUUID().toString();
    private Map<String, Object> state = null;
    private String nodeId = null;
    private String nextNodeId = null;

    private Checkpoint() {
    }

    public Checkpoint(Checkpoint checkpoint) {
        this.id = checkpoint.id;
        this.state = checkpoint.state;
        this.nodeId = checkpoint.nodeId;
        this.nextNodeId = checkpoint.nextNodeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Checkpoint updateState(Map<String, Object> values, Map<String, Channel<?>> channels) {
        Checkpoint result = new Checkpoint(this);
        result.state = AgentState.updateState(this.state, values, channels);
        return result;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getState() {
        return this.state;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getNextNodeId() {
        return this.nextNodeId;
    }

    public String toString() {
        return "Checkpoint(id=" + this.getId() + ", state=" + this.getState() + ", nodeId=" + this.getNodeId() + ", nextNodeId=" + this.getNextNodeId() + ")";
    }

    public static class Builder {
        private final Checkpoint result = new Checkpoint();

        public Builder id(String id) {
            this.result.id = id;
            return this;
        }

        public Builder state(AgentState state) {
            this.result.state = state.data();
            return this;
        }

        public Builder state(Map<String, Object> state) {
            this.result.state = state;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.result.nodeId = nodeId;
            return this;
        }

        public Builder nextNodeId(String nextNodeId) {
            this.result.nextNodeId = nextNodeId;
            return this;
        }

        public Checkpoint build() {
            Objects.requireNonNull(this.result.id, "Checkpoint.id cannot be null");
            Objects.requireNonNull(this.result.state, "Checkpoint.state cannot be null");
            Objects.requireNonNull(this.result.nodeId, "Checkpoint.nodeId cannot be null");
            Objects.requireNonNull(this.result.nextNodeId, "Checkpoint.nextNodeId cannot be null");
            return this.result;
        }
    }
}

