/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.checkpoint;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.NonNull;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.checkpoint.CheckPointSerializer;
import org.bsc.langgraph4j.checkpoint.Checkpoint;
import org.bsc.langgraph4j.checkpoint.MemorySaver;
import org.bsc.langgraph4j.serializer.Serializer;
import org.bsc.langgraph4j.serializer.StateSerializer;
import org.bsc.langgraph4j.state.AgentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemSaver
extends MemorySaver {
    private static final Logger log = LoggerFactory.getLogger(FileSystemSaver.class);
    private final Path targetFolder;
    private final Serializer<Checkpoint> serializer;

    public FileSystemSaver(@NonNull Path targetFolder, @NonNull StateSerializer<? extends AgentState> stateSerializer) {
        if (targetFolder == null) {
            throw new NullPointerException("targetFolder is marked non-null but is null");
        }
        if (stateSerializer == null) {
            throw new NullPointerException("stateSerializer is marked non-null but is null");
        }
        File targetFolderAsFile = targetFolder.toFile();
        if (targetFolderAsFile.exists()) {
            if (targetFolderAsFile.isFile()) {
                throw new IllegalArgumentException(String.format("targetFolder '%s' must be a folder", targetFolder));
            }
        } else if (!targetFolderAsFile.mkdirs()) {
            throw new IllegalArgumentException(String.format("targetFolder '%s' cannot be created", targetFolder));
        }
        this.targetFolder = targetFolder;
        this.serializer = new CheckPointSerializer(stateSerializer);
    }

    private File getFile(RunnableConfig config) {
        return config.threadId().map(threadId -> Paths.get(this.targetFolder.toString(), String.format("thread-%s.saver", threadId))).orElseGet(() -> Paths.get(this.targetFolder.toString(), "thread-$default.saver")).toFile();
    }

    private void serialize(@NonNull LinkedList<Checkpoint> checkpoints, @NonNull File outFile) throws IOException {
        if (checkpoints == null) {
            throw new NullPointerException("checkpoints is marked non-null but is null");
        }
        if (outFile == null) {
            throw new NullPointerException("outFile is marked non-null but is null");
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));){
            oos.writeInt(checkpoints.size());
            for (Checkpoint checkpoint : checkpoints) {
                this.serializer.write(checkpoint, oos);
            }
        }
    }

    private void deserialize(@NonNull File file, @NonNull LinkedList<Checkpoint> result) throws IOException, ClassNotFoundException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            int size = ois.readInt();
            for (int i = 0; i < size; ++i) {
                result.add(this.serializer.read(ois));
            }
        }
    }

    @Override
    protected LinkedList<Checkpoint> getCheckpoints(RunnableConfig config) {
        LinkedList<Checkpoint> result = super.getCheckpoints(config);
        File targetFile = this.getFile(config);
        if (targetFile.exists() && result.isEmpty()) {
            try {
                this.deserialize(targetFile, result);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public boolean clear(RunnableConfig config) {
        File targetFile = this.getFile(config);
        return targetFile.exists() && targetFile.delete();
    }

    @Override
    public Collection<Checkpoint> list(RunnableConfig config) {
        return super.list(config);
    }

    @Override
    public Optional<Checkpoint> get(RunnableConfig config) {
        return super.get(config);
    }

    @Override
    public RunnableConfig put(RunnableConfig config, Checkpoint checkpoint) throws Exception {
        RunnableConfig result = super.put(config, checkpoint);
        File targetFile = this.getFile(config);
        this.serialize(super.getCheckpoints(config), targetFile);
        return result;
    }
}

