/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.checkpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.IntStream;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.checkpoint.BaseCheckpointSaver;
import org.bsc.langgraph4j.checkpoint.Checkpoint;

public class MemorySaver
implements BaseCheckpointSaver {
    private final Map<String, LinkedList<Checkpoint>> _checkpointsByThread = new HashMap<String, LinkedList<Checkpoint>>();
    private final LinkedList<Checkpoint> _defaultCheckpoints = new LinkedList();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    protected LinkedList<Checkpoint> getCheckpoints(RunnableConfig config) {
        return config.threadId().map(threadId -> this._checkpointsByThread.computeIfAbsent((String)threadId, k -> new LinkedList())).orElse(this._defaultCheckpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Checkpoint> list(RunnableConfig config) {
        LinkedList<Checkpoint> checkpoints = this.getCheckpoints(config);
        this.r.lock();
        try {
            Collection<Checkpoint> collection = Collections.unmodifiableCollection(checkpoints);
            return collection;
        }
        finally {
            this.r.unlock();
        }
    }

    protected Optional<Checkpoint> getLast(LinkedList<Checkpoint> checkpoints, RunnableConfig config) {
        return checkpoints.isEmpty() ? Optional.empty() : Optional.ofNullable(checkpoints.peek());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Checkpoint> get(RunnableConfig config) {
        LinkedList<Checkpoint> checkpoints = this.getCheckpoints(config);
        this.r.lock();
        try {
            if (config.checkPointId().isPresent()) {
                Optional<Checkpoint> optional = config.checkPointId().flatMap(id -> checkpoints.stream().filter(checkpoint -> checkpoint.getId().equals(id)).findFirst());
                return optional;
            }
            Optional<Checkpoint> optional = this.getLast(checkpoints, config);
            return optional;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunnableConfig put(RunnableConfig config, Checkpoint checkpoint) throws Exception {
        LinkedList<Checkpoint> checkpoints = this.getCheckpoints(config);
        this.w.lock();
        try {
            if (config.checkPointId().isPresent()) {
                String checkPointId = config.checkPointId().get();
                int index = IntStream.range(0, checkpoints.size()).filter(i -> ((Checkpoint)checkpoints.get(i)).getId().equals(checkPointId)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("Checkpoint with id %s not found!", checkPointId)));
                checkpoints.set(index, checkpoint);
                RunnableConfig runnableConfig = config;
                return runnableConfig;
            }
            checkpoints.push(checkpoint);
            RunnableConfig runnableConfig = RunnableConfig.builder(config).checkPointId(checkpoint.getId()).build();
            return runnableConfig;
        }
        finally {
            this.w.unlock();
        }
    }
}

