/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.diagram;

import org.bsc.langgraph4j.DiagramGenerator;
import org.bsc.langgraph4j.StateGraph;

public class MermaidGenerator
extends DiagramGenerator {
    @Override
    protected void appendHeader(StringBuilder sb, String title) {
        sb.append(String.format("---\ntitle: %s\n---\n", title)).append("flowchart TD\n").append(String.format("\t%s((start))\n", StateGraph.START)).append(String.format("\t%s((stop))\n", StateGraph.END));
    }

    @Override
    protected void appendFooter(StringBuilder sb) {
    }

    @Override
    protected void declareConditionalStart(StringBuilder sb, String name) {
        sb.append(String.format("\t%s{\"check state\"}\n", name));
    }

    @Override
    protected void declareNode(StringBuilder sb, String name) {
        sb.append(String.format("\t%s(\"%s\")\n", name, name));
    }

    @Override
    protected void declareConditionalEdge(StringBuilder sb, int ordinal) {
        sb.append(String.format("\tcondition%d{\"check state\"}\n", ordinal));
    }

    @Override
    protected StringBuilder commentLine(StringBuilder sb, boolean yesOrNo) {
        return yesOrNo ? sb.append("\t%%") : sb;
    }

    @Override
    protected void start(StringBuilder sb, String entryPoint) {
        this.call(sb, StateGraph.START, entryPoint);
    }

    @Override
    protected void finish(StringBuilder sb, String finishPoint) {
        this.call(sb, finishPoint, StateGraph.END);
    }

    @Override
    protected void finish(StringBuilder sb, String finishPoint, String description) {
        this.call(sb, finishPoint, StateGraph.END, description);
    }

    @Override
    protected void call(StringBuilder sb, String from, String to) {
        sb.append(String.format("\t%1$s:::%1$s --> %2$s:::%2$s\n", from, to));
    }

    @Override
    protected void call(StringBuilder sb, String from, String to, String description) {
        sb.append(String.format("\t%1$s:::%1$s -->|%2$s| %3$s:::%3$s\n", from, description, to));
    }
}

