/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Objects;

public interface Serializer<T> {
    public void write(T var1, ObjectOutput var2) throws IOException;

    public T read(ObjectInput var1) throws IOException, ClassNotFoundException;

    default public String mimeType() {
        return "application/octet-stream";
    }

    default public byte[] writeObject(T object) throws IOException {
        Objects.requireNonNull(object, "object cannot be null");
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ObjectOutputStream oas = new ObjectOutputStream(stream);
            this.write(object, oas);
            oas.flush();
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    default public T readObject(byte[] bytes) throws IOException, ClassNotFoundException {
        Objects.requireNonNull(bytes, "bytes cannot be null");
        if (bytes.length == 0) {
            throw new IllegalArgumentException("bytes cannot be empty");
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            ObjectInputStream ois = new ObjectInputStream(stream);
            T t = this.read(ois);
            return t;
        }
    }

    default public T cloneObject(T object) throws IOException, ClassNotFoundException {
        Objects.requireNonNull(object, "object cannot be null");
        return this.readObject(this.writeObject(object));
    }
}

