/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer;

import java.io.IOException;
import java.util.Map;
import lombok.NonNull;
import org.bsc.langgraph4j.serializer.Serializer;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AgentStateFactory;

public abstract class StateSerializer<State extends AgentState>
implements Serializer<State> {
    private final AgentStateFactory<State> stateFactory;

    protected StateSerializer(@NonNull AgentStateFactory<State> stateFactory) {
        if (stateFactory == null) {
            throw new NullPointerException("stateFactory is marked non-null but is null");
        }
        this.stateFactory = stateFactory;
    }

    public final AgentStateFactory<State> stateFactory() {
        return this.stateFactory;
    }

    public final State stateOf(@NonNull Map<String, Object> data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return (State)((AgentState)this.stateFactory.apply(data));
    }

    @Override
    public final State cloneObject(@NonNull Map<String, Object> data) throws IOException, ClassNotFoundException {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return (State)this.cloneObject((AgentState)this.stateFactory().apply(data));
    }
}

