/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.plain_text;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import lombok.NonNull;
import org.bsc.langgraph4j.serializer.StateSerializer;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AgentStateFactory;

public abstract class PlainTextStateSerializer<State extends AgentState>
extends StateSerializer<State> {
    protected PlainTextStateSerializer(@NonNull AgentStateFactory<State> stateFactory) {
        super(stateFactory);
        if (stateFactory == null) {
            throw new NullPointerException("stateFactory is marked non-null but is null");
        }
    }

    @Override
    public String mimeType() {
        return "plain/text";
    }

    public State read(String data) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytesStream);){
            out.writeUTF(data);
            out.flush();
        }
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytesStream.toByteArray()));){
            AgentState agentState = (AgentState)this.read(in);
            return (State)agentState;
        }
    }

    public State read(Reader reader) throws IOException, ClassNotFoundException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
        }
        return this.read(sb.toString());
    }
}

