/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.std;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Optional;
import org.bsc.langgraph4j.serializer.Serializer;

public interface NullableObjectSerializer<T>
extends Serializer<T> {
    default public void writeNullableObject(Object object, ObjectOutput out) throws IOException {
        if (object == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeObject(object);
        }
    }

    default public Optional<Object> readNullableObject(ObjectInput in) throws IOException, ClassNotFoundException {
        byte b = in.readByte();
        return b == 0 ? Optional.empty() : Optional.of(in.readObject());
    }

    default public void writeNullableUTF(String object, ObjectOutput out) throws IOException {
        if (object == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(object);
        }
    }

    default public Optional<String> readNullableUTF(ObjectInput in) throws IOException {
        byte b = in.readByte();
        if (b == 0) {
            return Optional.empty();
        }
        return Optional.of(in.readUTF());
    }
}

